let system = require("../../../system");
let settings = require("../../../../config/settings");
const AppServiceBase = require("../../app.base");

class IcpNeedService extends AppServiceBase {
    constructor() {
        super();
        this.utilsPushSve = system.getObject("service.utilsSve.utilsPushSve");
    }

    async submitNeed(pobj) {
        console.log("pobj+++++++++++++++++++++++++", JSON.stringify(pobj))
        if (!pobj.intentionBizId) {
            return system.getResult(null, "actionBody.intentionBizId can not be empty，6000001");
        }
        let productTypeParams = {
            actionType: "getProductTypeInfo",
            appInfo: pobj.appInfo,
            actionBody: {type: pobj.consultType}
        }
        let url = settings.centerAppUrl() + "action/opProduct/springBoard";
        let rtn = await this.execClient.execPost(productTypeParams, url);
        if (!rtn || !rtn.stdout) {
            return system.getResultFail(-5015, "需求类型查询失败，6000002");
        }
        let productItem = JSON.parse(rtn.stdout);
        if (productItem.status != 0) {
            return system.getResultFail(-5015, "需求类型查询失败6000003");
        }

        // pobj.actionBody.type = "baidu.icp";
        // pobj.actionBody.idempotentSource = "baidu_icp";

        //推送云服需要的type、idempotentSource两个参数确定，先去掉试一试
        // if (pobj.actionBody.channel_type_code == 5) {
        //     pobj.actionBody.type = "baidu.icp";
        //     pobj.actionBody.idempotentSource = "baidu_icp";
        // } else if (pobj.actionBody.channel_type_code == 7) {
        //     pobj.actionBody.type = "baidu.edi";
        //     pobj.actionBody.idempotentSource = "baidu_edi";
        // } else if (pobj.actionBody.channel_type_code == "NC") {
        //     pobj.actionBody.type = "baidu.wangwen";
        //     pobj.actionBody.idempotentSource = "baidu_wangwen";
        // } else if (pobj.actionBody.channel_type_code == "RT") {
        //     pobj.actionBody.type = "baidu.radiotv";
        //     pobj.actionBody.idempotentSource = "baidu_radiotv";
        // }
        // if (pobj.appInfo && pobj.appInfo.uapp_id && pobj.appInfo.uapp_id == "52") {
        //     if (pobj.actionBody.channel_type_code == 5) {
        //         pobj.actionBody.type = "yiming.icp";
        //         pobj.actionBody.idempotentSource = "yiming.icp";
        //     } else if (pobj.actionBody.channel_type_code == 7) {
        //         pobj.actionBody.type = "yiming.edi";
        //         pobj.actionBody.idempotentSource = "yiming.edi";
        //     } else if (pobj.actionBody.channel_type_code == "ICPNB") {
        //         pobj.actionBody.type = "yiming.icpnb";
        //         pobj.actionBody.idempotentSource = "yiming.icpnb";
        //     } else if (pobj.actionBody.channel_type_code == "EDINB") {
        //         pobj.actionBody.type = "yiming.edinb";
        //         pobj.actionBody.idempotentSource = "yiming.edinb";
        //     } else if (pobj.actionBody.channel_type_code == "ICPXQ") {
        //         pobj.actionBody.type = "yiming.icpxq";
        //         pobj.actionBody.idempotentSource = "yiming.icpxq";
        //     } else if (pobj.actionBody.channel_type_code == "EDIXQ") {
        //         pobj.actionBody.type = "yiming.edixq";
        //         pobj.actionBody.idempotentSource = "yiming.edixq";
        //     }
        //     //外资暂时产品库未上架
        //     else if (pobj.actionBody.channel_type_code == "ICPWZ") {
        //         pobj.actionBody.type = "yiming.icpwz";
        //         pobj.actionBody.idempotentSource = "yiming.icpwz";
        //     } else if (pobj.actionBody.channel_type_code == "EDIWZ") {
        //         pobj.actionBody.type = "yiming.ediwz";
        //         pobj.actionBody.idempotentSource = "yiming.ediwz";
        //     }
        // }
        let submitNeedParams = {
            actionType: "submitNeed",
            appInfo: pobj.appInfo,
            actionBody: {
                intentionBizId: pobj.intentionBizId,
                phone: pobj.phone,
                userName: pobj.userName,
                description: pobj.description,
                area: pobj.area,
                consultType: pobj.consultType,
                mobile: pobj.mobile,
                type: pobj.consultType || pobj.channel_type_code,

                service_product_id: productItem.data.service_product_id,
                productId: productItem.data.service_product_id,
                appName: pobj.appInfo.app_name,
                type_code: productItem.data.type_code,
                type_name: productItem.data.type_name,
                channel_type_code: productItem.data.channel_type_code,
                channel_type_name: productItem.data.channel_type_name,
                idempotentId: pobj.intentionBizId,
                idempotentSourceName: pobj.appInfo.app_name,
                level: "A"
            }
        }
        console.log("submitNeed--------------------------submitNeedParams----", JSON.stringify(submitNeedParams));
        let reqUrl = settings.centerOrderUrl() + "action/need/springBoard";
        let result = await this.restPostUrl(submitNeedParams, reqUrl);
        if (result.status == 0) {
            this.utilsPushSve.business2Channel(submitNeedParams, "pushNeedICPBusinessNew");
        }
        return result;
    }
}

module.exports = IcpNeedService;