const system = require("../../../system")
const AppServiceBase = require("../../app.base")
const settings = require("../../../../config/settings")
class AskForService extends AppServiceBase {
  constructor() {
    super();
    this.restClient = system.getObject("util.restClient")
    this.centerOrderUrl = settings.centerOrderUrl()
    this.centerCacheUrl = settings.centerCacheUrl()
  }


  /**
   * @description 商标尼斯查询
   * @author liangwk
   * @param {*} param
   * @returns 
   * @memberof AskForService
   */
  async niceQuery (param) {
    let url = `${this.centerCacheUrl}tm_treasure_name`
    let result = await this.restClient.execPost(param, url)
    result = result.stdout
    result = JSON.parse(result)
    return result;
  }

  /**
   * @description 获取收藏列表
   * @author liangwk
   * @param {*} pobj
   * @returns 
   * @memberof AskForService
   */
  async getCollect (pobj) {
    if (pobj.actionBody.collections) {
      pobj.actionType = 'getByUidAndCollections'
    } else {
      pobj.actionType = 'getByUid'
    }
    let url = `${this.centerOrderUrl}askfor/collect/tradeMark`
    let result = await this.restClient.execPost(pobj, url)
    result = result.stdout
    result = JSON.parse(result)
    return result
  }


  /**
   * @description
   * @author liangwk
   * @param {*} pobj
   * @returns 
   * @memberof AskForService
   */
  async collect (pobj) {
    pobj.actionType = pobj.actionBody.id ? 'delete' : 'create'
    let url = `${this.centerOrderUrl}askfor/collect/tradeMark`
    let result = await this.restClient.execPost(pobj, url)
    result = result.stdout
    result = JSON.parse(result)
    return result
  }

  async getAskFor (pobj) {
    pobj.actionType = 'getByUid'
    let url = `${this.centerOrderUrl}askfor/askfor/tradeMark`
    let result = await this.restClient.execPost(pobj, url)
    result = result.stdout
    result = JSON.parse(result)
    return result
  }

  async askFor (pobj) {
    pobj.actionType = pobj.actionBody.id ? 'delete' : 'create'
    let url = `${this.centerOrderUrl}askfor/askfor/tradeMark`
    let result = await this.restClient.execPost(pobj, url)
    result = result.stdout
    result = JSON.parse(result)
    return result
  }
}
module.exports = AskForService;