const CacheBase=require("../cache.base");
const system=require("../../system");
// const OpenplatformWxop =  require("../../wxop/impl/openplatformWxop");
/**
 * 飞书小程序--AppTicket缓存--有效时间3600s
 */
class feishuAppTicketCache extends CacheBase{
   constructor(){
     super();
     this.restClient = system.getObject("util.restClient");
     this.prefix="feishu_appTicket_cli_9e28dcb1d637100d";
   }
    desc() {
        return "应用UI配置缓存";
    }
    prefix() {
        return "feishu_appTicket_cli_9e28dcb1d637100d";
    }
   async get(){
      var key = this.prefix;
      var result = await this.redisClient.get(key);
      return result
   }
   async set(appTicket){
      var key = this.prefix;
      if(appTicket){
         await this.redisClient.setWithEx(key,appTicket,3600);
      }
      return appTicket;
   }
}
module.exports=feishuAppTicketCache;