const system = require("../system");
const settings = require("../../config/settings");
const uuidv4 = require('uuid/v4');
const md5 = require("MD5");
class WEBBase {
    constructor() {
        this.execClientNew = system.getObject("util.execClientNew");
        this.restClient = system.getObject("util.restClient");
        this.execClientNew = system.getObject("util.execClientNew");
        this.cacheManager = system.getObject("db.common.cacheManager");
        this.logCtl = system.getObject("service.common.oplogSve");
        this.toolSve = system.getObject("service.trademark.toolSve");
        this.exTime = 6 * 3600;//缓存过期时间，6小时
    }
    getUUID() {
        var uuid = uuidv4();
        var u = uuid.replace(/\-/g, "");
        return u;
    }
    //-----------------------新的模式------------------开始

    async doexecMethod(gname, methodname, pobj, query, req) {
        req.requestId = this.getUUID();
        try {
            var result = await this[methodname](pobj, query, req);
            if (!result.requestId) {
                result.requestId = pobj.RequestId ? pobj.RequestId : pobj.requestId || req.requestId;
            }
            this.logCtl.createDb({
                appid: req.app.id,
                appkey: req.app.uappKey,
                requestId: req.requestId,
                op: req.classname + "/" + methodname,
                content: JSON.stringify(pobj),
                resultInfo: JSON.stringify(result),
                clientIp: req.clientIp,
                agent: req.uagent,
                opTitle: "api服务提供方appKey:" + settings.appKey,
            });
            var tmpResult = pobj.actionType && pobj.actionType.indexOf("List") < 0 ? result : { status: result.status, message: result.message, requestId: result.requestId };
            this.execClientNew.execLogs("web-center-channel--reqPath:" + req.path, pobj, "center-channel-doexecMethod-web", tmpResult, null);
            return result;
        } catch (e) {
            console.log(e.stack, "api调用出现异常，请联系管理员..........")
            this.logCtl.createDb({
                appid: req.app.id,
                appkey: req.app.uappKey,
                requestId: req.requestId,
                op: req.classname + "/" + methodname,
                content: JSON.stringify(pobj),
                resultInfo: JSON.stringify(e.stack),
                clientIp: req.clientIp,
                agent: req.uagent,
                opTitle: "api调用出现异常，请联系管理员error，appKey:" + settings.appKey,
            });
            // this.logCtl.error({
            //     appid: req.app.id,
            //     appkey: req.app.uappKey,
            //     requestId: req.requestId,
            //     op: req.classname + "/" + methodname,
            //     content: e.stack,
            //     clientIp: pobj.clientIp,
            //     agent: req.uagent,
            //     optitle: "api调用出现异常，请联系管理员",
            // });
            var rtnerror = system.getResultFail(-200, "出现异常，error：" + e.stack);
            rtnerror.requestId = req.requestId;
            return rtnerror;
        }
    }

    //-----------------------新的模式------------------结束

    async restPostUrl(pobj, url) {
        var rtn = await this.restClient.execPost(pobj, url);
        if (!rtn || !rtn.stdout) {
            return system.getResult(null, "restPost data is empty");
        }
        var result = JSON.parse(rtn.stdout);
        return result;
    }
    /**
* 带超时时间的post请求
* @param {*} req 请求信息
* @param {*} params 请求数据-json格式
* @param {*} url 请求地址
* @param {*} ContentType 请求头类型，默认application/json
* @param {*} headData 请求头内容-json格式，如：请求头中传递token,格式：{token:"9098902q849q0434q09439"}
* @param {*} timeOut 超时时间
*/
    async execPostByTimeOut(req, params, url, ContentType, headData, timeOut = 60) {
        const result = await this.execClientNew.execPostTimeOutByBusiness('sve.base', params, url, ContentType, headData, timeOut, req);
        return result;
    }
}
module.exports = WEBBase;
