let APIBase = require("../../api.base");
let system = require("../../../system");
let settings = require("../../../../config/settings");
const uuidv4 = require('uuid/v4');

/**
 * 增值服务需求服务
 */
class Consultation extends APIBase {
    constructor() {
        super();
        this.gatewaypushlogSve = system.getObject("service.common.gatewaypushlogSve");
    }

    //icp需求提交
    async submit(pobj, obj, req) {
        if (!pobj.appInfo || !pobj.appInfo.uapp_key || !pobj.appInfo.uapp_secret) {
            return system.getResultFailByErrMsg("未知应用或应用未启用");
        }
        if (!pobj.intentionBizId) {
            return system.getResultFailByErrMsg("intentionBizId不能为空");
        }
        if (!pobj.phone) {
            return system.getResultFailByErrMsg("mobile不能为空");
        }
        if (!pobj.consultType) {
            return system.getResultFailByErrMsg("consultType不能为空");
        }
        if (pobj.consultType == "ICP") {
            pobj.consultType = "5";
        }
        if (pobj.consultType == "EDI") {
            pobj.consultType = "7";
        }
        pobj.area = settings.areaConfig[pobj.area];
        pobj.type = pobj.consultType;
        pobj.mobile = pobj.phone;
        // pobj.action_type = "submitIcpNeed";
        if (!pobj.area) {
            return self.getResultFail("area参数错误");
        }
        let param = {
            requestId: req.requestId || "",
            // requestUrl: "/icp/consultation/submit",
            requestjson: JSON.stringify(pobj),//请求地址
            // pushUrl: "/action/intentionapi/springBoard",//调用地址
            // pushActionType: "submitIcpNeed",//调用参数
            pushtimes: 0,//推送次数
            pushStatus: "wts",//推送状态
            version: 1,
            interface_path: "service.receiveSve.icpNeedSve",//接口路径
            interface_method: "submitNeed",//接口方法
        }
        await this.gatewaypushlogSve.create(param);
        return system.getResultSuccess(null);
    }
}

module.exports = Consultation;