const system = require("../../../system");
const Dao = require("../../dao.base");
class DeliveruserDao extends Dao {
  constructor() {
    super(Dao.getModelName(DeliveruserDao));
  }

  async findByUcname(ucname) {
    let sql = "SELECT * FROM d_deliver_user WHERE ucname = :ucname";
    let list = await this.customQuery(sql, {ucname: ucname});
    if(!list) {
      return null;
    }
    return list[0];
  }

  async findListByIds(ids) {
    if (!ids || ids.length == 0) {
      return [];
    }
    var sql = [];
    sql.push("SELECT");
    sql.push("*");
    sql.push("FROM d_deliver_user");
    sql.push("WHERE id IN (:ids)");
    return await this.customQuery(sql.join(" "), {
      ids: ids
    }) || [];
  }

  async findMapByIds(ids) {
    var result = {};
    if (!ids || ids.length == 0) {
      return result;
    }
    var list = await this.findListByIds(ids);
    if (!list || list.length == 0) {
      return result;
    }
    for (var item of list) {
      result[item.id] = item;
    }
    return result;
  }
}
module.exports = DeliveruserDao;
// var u=new UserDao();
// var roledao=system.getObject("db.roleDao");
// (async ()=>{
//   var users=await u.model.findAll({where:{app_id:1}});
//   var role=await roledao.model.findOne({where:{code:"guest"}});
//   console.log(role);
//   for(var i=0;i<users.length;i++){
//     await users[i].setRoles([role]);
//     console.log(i);
//   }
//
// })();