const fs = require("fs");
const settings = require("../../../../config/settings");
class CacheManager {
  constructor() {
    //await this.buildCacheMap();
    this.buildCacheMap();

  }
  buildCacheMap() {
    var self = this;
    self.doc = {};
    var cachePath = settings.basepath + "/app/base/db/cache/";
    const files = fs.readdirSync(cachePath);
    if (files) {
      files.forEach(function (r) {
        var classObj = require(cachePath + "/" + r);
        if (classObj.name) {
          self[classObj.name] = new classObj();
          var refTmp = self[classObj.name];
          if (refTmp.prefix) {
            self.doc[refTmp.prefix] = refTmp.desc;
          } else {
            console.log("请在" + classObj.name + "缓存中定义prefix");
          }
        }
      });
    }
  }
}
module.exports = CacheManager;
// var cm= new CacheManager();
// cm["InitGiftCache"].cacheGlobalVal("hello").then(function(){
//   cm["InitGiftCache"].cacheGlobalVal().then(x=>{
//     console.log(x);
//   });
// });