const system = require("../../../system");
const Dao = require("../../dao.base");
class BusinessscopeDao extends Dao {
  constructor() {
    super(Dao.getModelName(BusinessscopeDao));
  }

  async findListByDomicileIds(domicileIds) {
    if (!domicileIds || domicileIds.length == 0) {
      return [];
    }
    var sql = [];
    sql.push("SELECT");
    sql.push("id, domicile_id, businessType,");
    sql.push("businessscope, isEnabled, created_at ");
    sql.push("FROM d_businessscope");
    sql.push("WHERE domicile_id IN (:domicileIds)");
    return await this.customQuery(sql.join(" "), {
      domicileIds: domicileIds
    }) || [];
  }

  async findMapByDomicileIds(domicileIds) {
    var result = {};
    if (!domicileIds || domicileIds.length == 0) {
      return result;
    }
    var list = await this.findListByDomicileIds(domicileIds);
    if (!list || list.length == 0) {
      return result;
    }
    for (var item of list) {
      var domicileList = result[item.domicile_id] || [];
      domicileList.push(item);
      result[item.domicile_id] = domicileList;
    }
    return result;
  }

  async delById(id, t) {
    var sql = "DELETE FROM d_businessscope WHERE id = :id";
    return await this.customUpdate(sql, {
      id: id
    }, t);
  }

  async delByDomicileId(domicileId, t) {
    var sql = "DELETE FROM d_businessscope WHERE domicile_id = :domicileId";
    return await this.customUpdate(sql, {
      domicileId: domicileId
    }, t);
  }
}
module.exports = BusinessscopeDao;
// var u=new UserDao();
// var roledao=system.getObject("db.roleDao");
// (async ()=>{
//   var users=await u.model.findAll({where:{app_id:1}});
//   var role=await roledao.model.findOne({where:{code:"guest"}});
//   console.log(role);
//   for(var i=0;i<users.length;i++){
//     await users[i].setRoles([role]);
//     console.log(i);
//   }
//
// })();