const url = require('url');
const qr = require('qr-image');
module.exports = function (app) {
  app.get('/api/qc', (req, res) => {
	    const params = url.parse(req.url, true);
	    const { detailLink } = params.query;
	    try {
	        const img = qr.image(detailLink, { size: 10 });
	        console.log(detailLink);
	        res.writeHead(200, { 'Content-Type': 'image/png' });
	        img.pipe(res);
	    } catch (e) {
	        res.writeHead(414, { 'Content-Type': 'text/html' });
	        res.end('<h1>414 Request-URI Too Large</h1>');
	    }
  });
};
