const express = require('express');
const path = require('path');
const favicon = require('serve-favicon');
const methodOverride = require('method-override');
const cookierParser = require('cookie-parser');
const bodyParser = require('body-parser');
const multer = require('multer');
const errorHandler = require('errorhandler');
const settings = require('./settings');
const system = require('../base/system');
const routes = require('./routes');
const history = require('connect-history-api-fallback');
module.exports = function (app) {
  app.set('port', settings.port);
  app.set('views', `${settings.basepath}/app/front/entry`);
  app.set('view engine', 'ejs');
  app.use(history());
  app.use(methodOverride());
  app.use(cookierParser());
  app.use(bodyParser.json({ limit: '50mb' }));
  app.use(bodyParser.urlencoded({ limit: '50mb', extended: true }));
  routes(app);// 初始化路由
  app.use(express.static(path.join(settings.basepath, '/app/front/entry/public')));
  // development only
  if (app.get('env') === 'development') {
    app.use(errorHandler());
  } else {
    app.use((err, req, res) => {
      console.log('prod error handler................................>>>>>>>>>>>>>>>>>');
      console.log(err);
      // logerApp.error("prod error handler",err);
      res.send('link admin');
    });
  }
};
