const system = require('../../../system');
const ServiceBase = require('../../sve.base');
const settings = require('../../../../config/settings');
const appconfig = system.getSysConfig();
class SettleBillService extends ServiceBase {
  constructor() {
    super('bizchance', ServiceBase.getDaoName(SettleBillService));
    this.deliverbillDao = system.getObject('db.bizchance.deliverybillDao');
  }
  async advice(id, msg, userId, userName) {
    const self = this;
    return this.db.transaction(async (t) => {
      // 先按照ids查询出交付单的合计服务成本
      const st = await self.dao.findById(id, { transaction: t });
      st.auditor_id = userId;
      st.auditor = userName;
      st.memo = msg;
      await st.save({ transaction: t });
      return st;
    });
  }
  async auditPass(settleId, userId, userName) {
    const self = this;
    return this.db.transaction(async (t) => {
      // 先按照ids查询出交付单的合计服务成本
      const st = await self.dao.findById(settleId, { transaction: t });
      st.auditedStatus = true;
      st.auditor_id = userId;
      st.auditor = userName;
      await st.save({ transaction: t });
      return st;
    });
  }
  async pay(settleId, userId, userName) {
    const self = this;
    return this.db.transaction(async (t) => {
      // 先按照ids查询出交付单的合计服务成本
      const st = await self.dao.findById(settleId, { transaction: t });
      st.isPayedStatus = true;
      st.payer_id = userId;
      st.payer = userName;
      await st.save({ transaction: t });
      // 改变所有交付单的结算settle_status settled ,
      await self.deliverbillDao.updateByWhere({ settle_status: 'settled' }, { settlebill_id: st.id }, t);
      return st;
    });
  }
  async delete(p) {
    const self = this;
    return this.db.transaction(async (t) => {
      const dobj = await self.dao.delete(p, t);
      // 更新交付单上结算状态为waittosettle--待结算，清空settlebill_id
      // waittosettle
      await self.deliverbillDao.updateByWhere({ settle_status: 'waittosettle', settlebill_id: null }, { settlebill_id: dobj.id }, t);
      return dobj;
    });
  }
}
module.exports = SettleBillService;
