const ServiceBase = require('../../sve.base');
class SchemeService extends ServiceBase {
  constructor() {
    super('bizchance', ServiceBase.getDaoName(SchemeService));
  }

  async findById(qobj) { // 根据id获取方案信息
    const oid = qobj.id;
    const result = await this.dao.findById(oid);
    return result;
  }

  async findInfoByDemandCode(qobj) { // 根据方案编号获取方案详情
    const result = await this.dao.findInfoByDemandCode(qobj);
    return result;
  }

  async updateStatusByDemandCode(qobj) { // 根据商机编号号更新方案状态及原因
    const self = this;
    return self.db.transaction(async (t) => {
      const result = await self.dao.updateStatusByDemandCode(qobj, t);
      return result;
    });
  }

  async updateInfoByDemandCode(qobj) { // 根据商机编号更新方案详情
    const self = this;
    return self.db.transaction(async (t) => {
      const result = await self.dao.updateInfoByDemandCode(qobj, t);
      return result;
    });
  }

  async updateSchemeNumberByDemandCode(qobj) { // 根据商机编号更新方案编号
    const self = this;
    return self.db.transaction(async (t) => {
      const result = await self.dao.updateSchemeNumberByDemandCode(qobj, t);
      return result;
    });
  }

  async insertInfo(qobj) { // 插入方案信息
    const self = this;
    const result = await self.db.transaction(async (t) => {
      const result = await self.dao.insertInfo(qobj, t);
      return result;
    });
    return result;
  }
}
module.exports = SchemeService;
