const system = require('../../../system');
const ServiceBase = require('../../sve.base');
const settings = require('../../../../config/settings');
const appconfig = system.getSysConfig();
class CacheInfoService extends ServiceBase {
  constructor() {
    super('bizchance', ServiceBase.getDaoName(CacheInfoService));
  }
  // async findAndCountAll(obj) {
  //     var self = this;
  //     const apps = await this.dao.findAndCountAll(obj);
  //     return apps;
  // }

  /* 根据交付单id获取缓存详情*/
  async findInfoByDeliverId(qobj) {
    const result = await this.dao.findInfoByDeliverId(qobj);
    return result;
  }

  /* 根据交付单id更新缓存信息 */
  async updateInfoByDeliverId(qobj) {
    const self = this;
    return self.db.transaction(async (t) => {
      const result = await self.dao.updateInfoByDeliverId(qobj, t);
      return result;
    });
  }

  /* 插入缓存信息*/
  async insertInfo(qobj) {
    const self = this;
    return self.db.transaction(async (t) => {
      const result = await self.dao.insertInfo(qobj, t);
      return result;
    });
  }
}
module.exports = CacheInfoService;
