const system = require('../../../system');
const ServiceBase = require('../../sve.base');
const settings = require('../../../../config/settings');
class DataauthService extends ServiceBase {
  constructor() {
    super('auth', ServiceBase.getDaoName(DataauthService));
  }
  async saveauth(obj) {
    // 先按照uid,modelname,检查是否存在，不存在创建，存在更新
    const oldauth = await this.dao.findOne({ user_id: obj.user_id, modelname: obj.modelname, app_id: obj.add_id });
    if (!oldauth) {
      return this.dao.create(obj);
    }
    obj.id = oldauth.id;
    return this.dao.update(obj);
  }
}
module.exports = DataauthService;
