const system = require('../../../system');
const moment = require('moment');
const settings = require('../../../../config/settings');
const appconfig = system.getSysConfig();
/**
 * 材料信息表
 */
module.exports = (db, DataTypes) => db.define('material', {
  delivery_id: { // 交付单id
    allowNull: true,
    type: DataTypes.INTEGER,
  },
  delivery_code: { // 交付单编号
    allowNull: true,
    type: DataTypes.STRING,
  },
  company_info: { // 企业信息
    allowNull: true,
    type: DataTypes.JSON,
  },
  registered_info: { // 注册资本信息
    allowNull: true,
    type: DataTypes.JSON,
  },
  contribution_info: { // 出资比例信息
    allowNull: true,
    type: DataTypes.JSON,
  },
  position_info: { // 任职信息
    allowNull: true,
    type: DataTypes.JSON,
  },
  file_info: { // 注册文件信息
    allowNull: true,
    type: DataTypes.JSON,
  },
  express_info: { // 邮寄信息
    allowNull: true,
    type: DataTypes.JSON,
  },
  is_download: { // 是否已有压缩文件的路径
    allowNull: true,
    type: DataTypes.INTEGER,
  },
  download_url: { // 压缩文件的路径
    allowNull: true,
    type: DataTypes.STRING,
  },
}, {
  paranoid: false, // 假的删除
  underscored: true,
  version: true,
  freezeTableName: true,
  // freezeTableName: true,
  // define the table's name
  tableName: 'material_information',
  validate: {

  },
  indexes: [
    // Create a unique index on email
    //  {
    //    unique: true,
    //    fields: ['email']
    //  },
    //
    //  // Creates a gin index on data with the jsonb_path_ops operator
    //  {
    //    fields: ['data'],
    //    using: 'gin',
    //    operator: 'jsonb_path_ops'
    //  },
    //
    //  // By default index name will be [table]_[fields]
    //  // Creates a multi column partial index
    //  {
    //    name: 'public_by_author',
    //    fields: ['author', 'status'],
    //    where: {
    //      status: 'public'
    //    }
    //  },
    //
    //  // A BTREE index with a ordered field
    //  {
    //    name: 'title_index',
    //    method: 'BTREE',
    //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
    //  }
  ],
});
