const system = require('../../../system');
const settings = require('../../../../config/settings');
const appconfig = system.getSysConfig();
/**
 * 交付单表
 */
module.exports = (db, DataTypes) => db.define('deliverybill', {
  delivery_code: { // 交付单编号
    allowNull: true,
    type: DataTypes.STRING,
  },
  source_number: { // 来源单号
    allowNull: true,
    type: DataTypes.STRING,
  },
  source_name: { // 渠道名称
    allowNull: true,
    type: DataTypes.STRING,
  },
  pay_status: { // 交付状态-虚拟字段
    allowNull: true,
    type: DataTypes.STRING,
  },
  v_coname: { // 联系人-虚拟字段
    allowNull: true,
    type: DataTypes.STRING,
  },
  v_cophone: { // 联系电话-虚拟字段
    allowNull: true,
    type: DataTypes.STRING,
  },
  demand_code: { // 商机编号
    allowNull: true,
    type: DataTypes.STRING,
  },
  sku_code: { // sku编码
    allowNull: true,
    type: DataTypes.STRING,
  },
  scheme_number: { // 方案编号
    allowNull: true,
    type: DataTypes.STRING,
  },
  product_code: { // 产品编码
    allowNull: false,
    type: DataTypes.STRING,
  },
  product_name: { // 产品名称
    allowNull: false,
    type: DataTypes.STRING,
  },
  service_address: { // 区域地址
    allowNull: false,
    type: DataTypes.STRING,
  },
  delivery_info: { // 服务概况
    allowNull: false,
    type: DataTypes.JSON,
  },
  delivery_status: { // 服务单流转状态
    allowNull: false,
    type: DataTypes.STRING,
  },
  master_source_number: { // 主订单号
    allowNull: false,
    type: DataTypes.STRING,
  },
  settle_status: { // 服务单流转状态
    allowNull: false,
    type: DataTypes.STRING,
    defaultValue: 'waittosettle',
  },
  selling_price: { // 售价
    allowNull: false,
    type: DataTypes.INTEGER,
  },
  cost_price: { // 成本价
    allowNull: true,
    type: DataTypes.INTEGER,
  },
  close_reason: { // 关闭理由
    allowNull: true,
    type: DataTypes.STRING,
  },
  facilitator_id: { // 服务商id
    allowNull: true,
    type: DataTypes.STRING,
  },
  facilitator_name: { // 服务商名称
    allowNull: true,
    type: DataTypes.STRING,
  },
  salesman_opcode: { // 组织架构路径
    allowNull: true,
    type: DataTypes.STRING,
  },
  salesman_id: { // 业务员id
    allowNull: true,
    type: DataTypes.STRING,
  },
  salesman_name: { // 业务员姓名
    allowNull: true,
    type: DataTypes.STRING,
  },
  salesman_phone: { // 业务员联系方式
    allowNull: true,
    type: DataTypes.STRING,
  },
  delivery_man_id: { // 交付员id
    allowNull: true,
    type: DataTypes.STRING,
  },
  delivery_man_name: { // 交付员姓名
    allowNull: true,
    type: DataTypes.STRING,
  },
  delivery_man_opcode: { // 交付员opcode
    allowNull: true,
    type: DataTypes.STRING,
  },

}, {
  paranoid: false, // 假的删除
  underscored: true,
  version: true,
  freezeTableName: true,
  // freezeTableName: true,
  // define the table's name
  tableName: 'delivery_bill',
  validate: {

  },
  indexes: [
    // Create a unique index on email
    //  {
    //    unique: true,
    //    fields: ['email']
    //  },
    //
    //  // Creates a gin index on data with the jsonb_path_ops operator
    //  {
    //    fields: ['data'],
    //    using: 'gin',
    //    operator: 'jsonb_path_ops'
    //  },
    //
    //  // By default index name will be [table]_[fields]
    //  // Creates a multi column partial index
    //  {
    //    name: 'public_by_author',
    //    fields: ['author', 'status'],
    //    where: {
    //      status: 'public'
    //    }
    //  },
    //
    //  // A BTREE index with a ordered field
    //  {
    //    name: 'title_index',
    //    method: 'BTREE',
    //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
    //  }
  ],
});

