module.exports = {
  config: {
    pdict: {
      app_type: { api: 'API服务', web: 'PCWEB', app: '移动APP', xcx: '小程序', access: '接入' },
      data_priv: { 'auth.role': '角色', 'auth.user': '用户' },
      noticeType: { sms: '短信', email: '邮件', wechat: '微信' },
      authType: { add: '新增', edit: '编辑', delete: '删除', export: '导出', show: '查看' },
      mediaType: { vd: '视频', ad: '音频', qt: '其它' },
      usageType: { kt: '课堂', taxkt: '财税课堂', qt: '其它' },
      opstatus: { 0: '失败', 1: '成功' },
      sex: { male: '男', female: '女' },
      logLevel: { debug: 0, info: 1, warn: 2, error: 3, fatal: 4 },
      msgType: { sys: '系统', single: '单点', multi: '群发' },
      node_type: { org: '组织', arc: '文档' },
      source: { // 渠道来源
        tencentCloud: '腾讯云',
      },

      businessType: { // 商机类型
        companyCase: '公司注册',
        psCase: '云上园区注册',
        agentCase: '代理记账',
        regAddrCase: '注册地址',
        icCheckCase: '工商年报',
        openBankAccountCase: '银行开户',
        taxCase: '税务报道',
        taxControlCase: '税控申请',
        sealSevCase: '刻章服务',
        icChangeCase: '工商变更',
        ssOpenCase: '社保开户',
        ICP: 'icp',
        EDI: 'edi',
        ICPANNUALREPORT: 'icp年报',
        EDIANNUALREPORT: 'edi年报',
        psAgentCase: '园区代理记账',
        psSealSevCase: '园区刻章服务',
      },

      businessStatus: { // 商机状态
        beforeSubmission: '待提交方案',
        beforeConfirmation: '待用户确认',
        isFinished: '已成交',
        isClosed: '已关闭',
      },

      businessSteps: [// 步骤条商机状态
        { title: '待提交方案', key: 'beforeSubmission' },
        { title: '待确认', key: 'beforeConfirmation' },
        { title: '已成交', key: 'isFinished' },
      ],

      businessSteps1: [// 步骤条商机状态-带关闭
        { title: '待提交方案', key: 'beforeSubmission' },
        { title: '待确认', key: 'beforeConfirmation' },
        { title: '已关闭', key: 'isClosed' },
      ],

      diliverCaseSteps1: [// 步骤条公司注册交付单状态
        { title: '已接单', content: '', key: 'received' },
        { title: '材料收集环节', content: '请配合顾问尽快提供', key: 'collecting' },
        { title: '工商审核环节', content: '10个工作日内', key: 'auditing' },
        { title: '刻章环节', content: '5个工作日内', key: 'engraving' },
        { title: '证件邮寄环节', content: '3个工作日内', key: 'posting' },
        { title: '已签收', key: 'signed' },
      ],

      diliverCaseSteps2: [// 步骤条云上园区交付单状态
        { title: '已接单', content: '', key: 'received' },
        { title: '材料收集环节', content: '请配合顾问尽快提供', key: 'collecting' },
        { title: '园区入驻审核', content: '1个工作日完成', key: 'checking' },
        { title: '工商审核环节', content: '10个工作日内', key: 'auditing' },
        { title: '刻章环节', content: '5个工作日内', key: 'engraving' },
        { title: '证件邮寄环节', content: '3个工作日内', key: 'posting' },
        { title: '已签收', key: 'signed' },
      ],

      diliverDetailsSteps1: [// 步骤条税务报道、税控申请、银行开户、工商年报、工商变更、社保开户、刻章服务交付状态
        { title: '已付款', key: 'paid' },
        { title: '已接单', key: 'received' },
        { title: '已交付', key: 'inservice' },
        { title: '已完成', key: 'success' },
      ],

      diliverDetailsSteps2: [// 步骤条代理记账、注册地址交付状态
        { title: '已付款', key: 'paid' },
        { title: '已接单', key: 'received' },
        { title: '已交付', key: 'inservice' },
        { title: '已到期', key: 'expired' },
      ],

      payStatus: { // 交付状态
        待交付: '待交付',
        已交付: '已交付',
        已关闭: '已关闭',
      },

      payStatus2: { // 增值服务的交付状态源数据
        待交付: '待交付',
        已交付: '已交付',
      },

      deliverStatus: { // 交付单状态
        received: '已接单', // 接单日期，公司注册云上园区
        collecting: '收集工商注册材料', // 请配合顾问尽快提供，公司注册
        uploading: '上传注册材料', // 请配合顾问尽快提供,云上园区注册
        checking: '园区入驻审核', // 1个工作日完成，云上园区注册
        auditing: '工商审核环节', // 10个工作日内，公司注册、云上园区
        engraving: '刻章环节', // 5个工作日内，只有选择了刻章服务时才有该状态
        posting: '证件邮寄环节', // 3个工作日内，公司注册、云上园区
        paid: '已付款', // 增值服务
        inservice: '已交付', // 增值服务
        success: '已完成', // 税务报道、税控申请、银行开户、工商年报、工商变更、社保开户、刻章服务
        signed: '已签收', // 公司注册、云上园区
        expired: '已到期', // 代理记账、注册地址
        closed: '已关闭', // 只有在已接单和收集工商注册材料阶段才能关闭交付
      },

      diliverStatus1: { // 公司注册交付单状态
        received: '已接单', // 接单日期
        collecting: '收集工商注册材料', // 请配合顾问尽快提供
        auditing: '工商审核环节', // 10个工作日内
        engraving: '刻章环节', // 5个工作日内，只有选择了刻章服务时才有该状态
        posting: '证件邮寄环节', // 3个工作日内
        signed: '已签收',
      },

      diliverSataus2: { // 云上园区注册交付状态
        received: '已接单', // 接单日期
        uploading: '上传注册材料', // 请配合顾问尽快提供
        checking: '园区入驻审核', // 1个工作日完成
        auditing: '工商审核环节', // 10个工作日内
        engraving: '刻章环节', // 5个工作日内，只有选择了刻章服务时才有该状态
        posting: '证件邮寄环节', // 3个工作日内
        signed: '已签收',
      },

      diliverSataus3: { // 税务报道、税控申请、银行开户、工商年报、工商变更、社保开户、刻章服务交付状态
        paid: '已付款',
        received: '已接单',
        inservice: '已交付',
        success: '已完成',
      },

      diliverSataus4: { // 代理记账、注册地址交付状态
        paid: '已付款',
        received: '已接单',
        inservice: '已交付',
        expired: '已到期',
      },

      registeredAreaDict: { // 注册地区
        110100: '北京',
        310100: '上海',
        330100: '杭州',
        370200: '青岛',
        320500: '苏州',
        330200: '宁波',
        320100: '南京',
        320200: '无锡',
        330300: '温州',
        130100: '石家庄',
        330700: '金华',
        320400: '常州',
        320600: '南通',
        320300: '徐州',
        330400: '嘉兴',
        331000: '台州',
        330600: '绍兴',
        140100: '太原',
        370600: '烟台',
        321000: '扬州',
        440100: '广州',
        440300: '深圳',
        510100: '成都',
        420100: '武汉',
        500100: '重庆',
        410100: '郑州',
        430100: '长沙',
        530100: '昆明',
        610100: '西安',
        441900: '东莞',
        350100: '福州',
        520100: '贵阳',
        360100: '南昌',
        440600: '佛山',
        120100: '天津',
        370100: '济南',
        210100: '沈阳',
        210200: '大连',
        230100: '哈尔滨',
        220100: '长春',
        340100: '合肥',
        410200: '开封',
        321300: '宿迁',
        370783: '寿光',
        442000: '中山',
        420500: '宜昌',
        350200: '厦门',
        350700: '南平',
      },
      TaxpayerTypeDict: { // 纳税人类型
        smallScaleTaxpayer: '小规模纳税人',
        generalTaxpayer: '一般纳税人',
      },
      TaxpayerTypeDictT: { // 纳税人类型取反
        小规模纳税人: 'smallScaleTaxpayer',
        一般纳税人: 'generalTaxpayer',
      },
      companyNatureDict: { // 公司类型
        limitedLiabilityCompany: '有限责任公司',
        incorporatedCompany: '股份有限公司',
        groupLimitedCompany: '集团公司',
      },
      companyNatureDictT: { // 公司类型取反
        有限责任公司: 'limitedLiabilityCompany',
        股份有限公司: 'incorporatedCompany',
        集团公司: 'groupLimitedCompany',
      },
      engagedIndustryDict: { // 从事行业
        culturalMedia: '文化传媒类',
        scienceAndTechnology: '科技类',
        filmIndustry: '影业类',
        trade: '贸易类',
        consult: '咨询类',
        advertisement: '广告类',
        administration: '管理类',
        lease: '租赁类',
        proxy: '代理类',
        train: '培训类',
        design: '设计类',
        service: '服务类',
        engineering: '工程类',
      },
      engagedIndustryDictT: { // 从事行业取反
        文化传媒类: 'culturalMedia',
        科技类: 'scienceAndTechnology',
        影业类: 'filmIndustry',
        贸易类: 'trade',
        咨询类: 'consult',
        广告类: 'advertisement',
        管理类: 'administration',
        租赁类: 'lease',
        代理类: 'proxy',
        培训类: 'train',
        设计类: 'design',
        服务类: 'service',
        工程类: 'engineering',
      },

      SealSevCaseDict: { // 是否刻章
        yes: '需要',
        no: '不需要',
      },

      financialDict: { // 财税服务
        yes: '需要',
        no: '不需要',
      },

      addressTypeDict: { // 经营地址类型
        practical: '实际经营地址',
        virtual: '虚拟地址',
      },
      registeredTypeDict: { // 个体户类型
        selfEmployed: '个体工商',
        soleProprietorship: '个人独资',
        company: '有限公司',
      },
      registeredTypeDictT: { // 个体户类型反
        个体工商: 'selfEmployed',
        个人独资: 'soleProprietorship',
        有限公司: 'company',
      },
      registeredParkDict: { // 注册园区
        410200: '开封',
        321300: '宿迁',
        310100: '上海',
        370783: '寿光',
        442000: '中山',
        420500: '宜昌',
        440600: '佛山',
        340100: '合肥',
        510100: '成都',
        500100: '重庆',
        350200: '厦门',
        350700: '南平',
        330100: '杭州',
        441900: '东莞',
      },

      sealSevTypeDict: { // 刻章类型
        company: '公司章',
        individual: '个体工商户章',
      },

      agentTypeDict: { // 代理记账主体类型
        company: '公司',
        individual: '个体户',
      },

      expressStatusDict: { // 邮寄状态
        beforeMailing: '待邮寄',
        mailed: '已邮寄',
        received: '已签收',
      },

      buyDurationDict: { // 购买时长
        buyDuration: '1年',
      },

      isRenewDict: { // 是否自动续费
        isRenew: '开启',
      },
      dyDict: { // 产品对应关系
        '/ic/gsreg/': 'companyCase',
        '/ic/kzfw/': 'sealSevCase',
        '/ic/cpreg/': 'psCase',
        '/ic/bankopen/': 'openBankAccountCase',
        '/ic/swbd/': 'taxCase',
        '/ic/sksq/': 'taxControlCase',
        '/ic/dljz/': 'agentCase',
        '/ic/regaddr/': 'regAddrCase',
        '/ic/gsnb/': 'icCheckCase',
        '/ic/gschangs/': 'icChangeCase',
        '/ic/sbopen/': 'ssOpenCase',
        '/qcfw/icp/': 'ICP',
        '/qcfw/edi/': 'EDI',
        '/qcfw/icpannals/': 'ICPANNUALREPORT',
        '/qcfw/ediannals/': 'EDIANNUALREPORT',
        '/ic/cpdljz/': 'psAgentCase',
        '/ic/cpkzfw/': 'psSealSevCase',
      },
      fdyDict: { // 产品反对应关系
        companyCase: '/ic/gsreg/',
        sealSevCase: '/ic/kzfw/',
        psCase: '/ic/cpreg/',
        openBankAccountCase: '/ic/bankopen/',
        taxCase: '/ic/swbd/',
        taxControlCase: '/ic/sksq/',
        agentCase: '/ic/dljz/',
        regAddrCase: '/ic/regaddr/',
        icCheckCase: '/ic/gsnb/',
        icChangeCase: '/ic/gschangs/',
        ssOpenCase: '/ic/sbopen/',
        ICP: '/qcfw/icp/',
        EDI: '/qcfw/edi/',
        ICPANNUALREPORT: '/qcfw/icpannals/',
        EDIANNUALREPORT: '/qcfw/ediannals/',
        psAgentCase: '/ic/cpdljz/',
        psSealSevCase: '/ic/cpkzfw/',
      },
      ddyDict: { // 和庄冰的交付单对应关系
        paid: 1,
        received: 20,
        inservice: 30,
        collecting: 100,
        uploading: 110,
        checking: 120,
        auditing: 130,
        engraving: 140,
        posting: 150,
        signed: 160,
        success: 170,
        expired: 180,
        closed: 190,
      },
      flowType: {
        BIZ: 'BIZ', // 商机表
        SCHEME: 'SCHEME', // 方案表
        DELIVERY: 'DELIVERY', // 服务单表
      },
      settle_status: {
        waittosettle: '待结算',
        settling: '结算中',
        settled: '已结算',
      },
      audit_status: {
        waittoaudit: '待审核',
        audited: '已审核',
      },
    },
  },
};
