const fs = require('fs');
const settings = require('../../../../config/settings');
class CacheManager {
  constructor() {
    // await this.buildCacheMap();
    this.buildCacheMap();
  }
  buildCacheMap() {
    const self = this;
    self.doc = {};
    const cachePath = `${settings.basepath}/app/base/db/cache/`;
    const files = fs.readdirSync(cachePath);
    if (files) {
      files.forEach((r) => {
        const classObj = require(`${cachePath}/${r}`);
        self[classObj.name] = new classObj();
        const refTmp = self[classObj.name];
        if (refTmp.prefix) {
          self.doc[refTmp.prefix] = refTmp.desc;
        } else {
          console.log(`请在${classObj.name}缓存中定义prefix`);
        }
      });
    }
  }
}
module.exports = CacheManager;
// var cm= new CacheManager();
// cm["InitGiftCache"].cacheGlobalVal("hello").then(function(){
//   cm["InitGiftCache"].cacheGlobalVal().then(x=>{
//     console.log(x);
//   });
// });
