const system = require('../../../system');
const Dao = require('../../dao.base');
class AppDao extends Dao {
  constructor() {
    super(Dao.getModelName(AppDao));
  }

  extraWhere(obj, w, qc, linkAttrs) {
    if (obj.bizpath && obj.bizpath != '') {
      if (obj.bizpath.indexOf('my_app') > 0) { // 说明是租户查询自己创建的应用
        w.creator_id = obj.userid;
      }
    }
    if (linkAttrs.length > 0) {
      const { search } = obj;
      const lnkKey = linkAttrs[0];
      const strq = `$${lnkKey.replace('~', '.')}$`;
      w[strq] = { [this.db.Op.like]: `%${search[lnkKey]}%` };
    }
    return w;
  }
}
module.exports = AppDao;
// var u=new UserDao();
// var roledao=system.getObject("db.roleDao");
// (async ()=>{
//   var users=await u.model.findAll({where:{app_id:1}});
//   var role=await roledao.model.findOne({where:{code:"guest"}});
//   console.log(role);
//   for(var i=0;i<users.length;i++){
//     await users[i].setRoles([role]);
//     console.log(i);
//   }
//
// })();
