const system = require('../../../system');
const Dao = require('../../dao.base');
class CacheinfoDao extends Dao {
  constructor() {
    super(Dao.getModelName(CacheinfoDao));
  }

  //   extraWhere(qobj, qw, qc) {//根据业务员id获取商机信息的组装条件
  //     qc.raw = true;
  //     qc.where.business_type = qc.where.business_type || {
  //       [this.db.Op.notIn]: ["ICP", "EDI"]
  //     }
  //     if(qobj.bizpath && qobj.bizpath!=""){
  //       if(qobj.bizpath.indexOf("myChance")>0){//说明是从商机列表过来的
  //         qw["salesman_id"]=qobj.userid;
  //       }
  //     }

  //     return qw;
  //   }

  /* 根据订单id获取缓存信息详情*/
  async findInfoByDeliverId(qobj) {
    const qcwhere = { deliver_id: qobj.deliverNumber };
    const result = await this.findOne(qcwhere);
    return result;
  }

  /* 更加订单id更新缓存信息*/
  async updateInfoByDeliverId(qobj, t) {
    const setobj = { cache_info: qobj.cacheInfo };
    const whereobj = { deliver_id: qobj.deliverNumber };
    const result = await this.updateByWhere(setobj, whereobj, t);
    return result;
  }

  /* 插入缓存信息*/
  async insertInfo(qobj, t) {
    const obj = {
      deliver_id: qobj.deliverNumber,
      cache_info: qobj.cacheInfo,
    };
    const result = await this.create(obj, t);
    return result;
  }
}
module.exports = CacheinfoDao;
