const system = require('../system');
class Dao {
  constructor(modelName) {
    this.modelName = modelName;
    const db = system.getObject('db.common.connection').getCon();
    this.db = db;
    console.log('........set dao model..........');
    console.log(this.modelName);
    this.model = db.models[this.modelName];
    console.log(this.modelName);
  }
  preCreate(u) {
    return u;
  }
  async create(u, t) {
    const u2 = this.preCreate(u);
    if (t) {
      console.log('>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>');
      // console.log( this.model);
      return this.model.create(u2, { transaction: t }).then(u => u);
    }
    return this.model.create(u2).then(u => u);
  }
  static getModelName(ClassObj) {
    return ClassObj.name.substring(0, ClassObj.name.lastIndexOf('Dao')).toLowerCase();
  }
  async refQuery(qobj) {
    const w = qobj.refwhere ? qobj.refwhere : {};
    if (qobj.levelinfo) {
      w[qobj.levelinfo.levelfield] = qobj.levelinfo.level;
    }
    if (qobj.parentinfo) {
      w[qobj.parentinfo.parentfield] = qobj.parentinfo.parentcode;
    }
    // 如果需要控制数据权限
    if (qobj.datapriv) {
      w.id = { [this.db.Op.in]: qobj.datapriv };
    }
    if (qobj.likestr) {
      w[qobj.fields[0]] = { [this.db.Op.like]: `%${qobj.likestr}%` };
      return this.model.findAll({ where: w, attributes: qobj.fields });
    }
    return this.model.findAll({ where: w, attributes: qobj.fields });
  }
  async bulkDelete(ids) {
    const en = await this.model.destroy({ where: { id: { [this.db.Op.in]: ids } } });
    return en;
  }
  async bulkDeleteByWhere(whereParam, t) {
    const en = null;
    if (t != null && t != 'undefined') {
      whereParam.transaction = t;
      const result = await this.model.destroy(whereParam);
      return result;
    }
    const result = await this.model.destroy(whereParam);
    return result;
  }
  async delete(qobj, t) {
    let en = null;
    if (t != null && t != 'undefined') {
      en = await this.model.findOne({ where: { id: qobj.id }, transaction: t });
      if (en != null) {
        await en.destroy({ transaction: t });
        return en;
      }
    } else {
      en = await this.model.findOne({ where: { id: qobj.id } });
      if (en != null) {
        return en.destroy();
      }
      return en;
    }
  }
  extraModelFilter(pobj) {
    // return {"key":"include","value":{model:this.db.models.app}};
    return null;
  }
  extraWhere(obj, where) {
    return where;
  }
  orderBy() {
    // return {"key":"include","value":{model:this.db.models.app}};
    return [['created_at', 'DESC']];
  }
  buildQuery(qobj) {
    const linkAttrs = [];
    const { pageNo } = qobj.pageInfo;
    const { pageSize } = qobj.pageInfo;
    const { search } = qobj;
    const qc = {};
    // 设置分页查询条件
    if (pageNo !== -1 && pageSize !== -1) {
      qc.limit = pageSize;
      qc.offset = (pageNo - 1) * pageSize;
    }
    // 默认的查询排序
    qc.order = this.orderBy();
    // 构造where条件
    qc.where = {};
    if (search) {
      Object.keys(search).forEach((k) => {
        console.log(search[k], ':search[k]search[k]search[k]');
        if (search[k] && search[k] != 'undefined' && search[k] != '') {
          if ((k.indexOf('Date') >= 0 || k.indexOf('_at') >= 0)) {
            if (search[k] != '' && search[k]) {
              const stdate = new Date(search[k][0]);
              const enddate = new Date(search[k][1]);
              qc.where[k] = { [this.db.Op.between]: [stdate, enddate] };
            }
          } else if (k.indexOf('id') >= 0) {
            qc.where[k] = search[k];
          } else if (k.indexOf('channelCode') >= 0) {
            qc.where[k] = search[k];
          } else if (k.indexOf('Type') >= 0) {
            qc.where[k] = search[k];
          } else if (k.indexOf('Status') >= 0) {
            qc.where[k] = search[k];
          } else if (k.indexOf('status') >= 0) {
            qc.where[k] = search[k];
          } else {
            if (k.indexOf('~') >= 0) {
              linkAttrs.push(k);
            } else {
              qc.where[k] = { [this.db.Op.like]: `%${search[k]}%` };
            }
          }
        }
      });
    }
    this.extraWhere(qobj, qc.where, qc, linkAttrs);
    const extraFilter = this.extraModelFilter(qobj);
    if (extraFilter) {
      qc[extraFilter.key] = extraFilter.value;
    }
    console.log('xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm');
    console.log(qc);
    return qc;
  }
  buildaggs(qobj) {
    const aggsinfos = [];
    if (qobj.aggsinfo) {
      qobj.aggsinfo.sum.forEach((aggitem) => {
        const t1 = [this.db.fn('SUM', this.db.col(aggitem.field)), `${aggitem.field}~` + 'sum'];
        aggsinfos.push(t1);
      });
      qobj.aggsinfo.avg.forEach((aggitem) => {
        const t2 = [this.db.fn('AVG', this.db.col(aggitem.field)), `${aggitem.field}~` + 'avg'];
        aggsinfos.push(t2);
      });
    }
    return aggsinfos;
  }
  async findAggs(qobj, qcwhere) {
    const aggArray = this.buildaggs(qobj);
    if (aggArray.length != 0) {
      qcwhere.attributes = {};
      qcwhere.attributes = aggArray;
      qcwhere.raw = true;
      const aggResult = await this.model.findOne(qcwhere);
      return aggResult;
    }
    return {};
  }
  async findAndCountAll(qobj, t) {
    const qc = this.buildQuery(qobj);
    const apps = await this.model.findAndCountAll(qc);
    const aggresult = await this.findAggs(qobj, qc);
    const rtn = {};
    rtn.results = apps;
    rtn.aggresult = aggresult;
    return rtn;
  }
  preUpdate(obj) {
    return obj;
  }
  async update(obj, tm) {
    const obj2 = this.preUpdate(obj);
    if (tm != null && tm != 'undefined') {
      return this.model.update(obj2, { where: { id: obj2.id }, transaction: tm });
    }
    return this.model.update(obj2, { where: { id: obj2.id } });
  }
  async bulkCreate(ids, t) {
    if (t != null && t != 'undefined') {
      const result = await this.model.bulkCreate(ids, { transaction: t });
      return result;
    }
    const result = await this.model.bulkCreate(ids);
    return result;
  }

  async updateByWhere(setObj, whereObj, t) {
    const inWhereObj = {};
    if (t && t != 'undefined') {
      if (whereObj && whereObj != 'undefined') {
        inWhereObj.where = whereObj;
        inWhereObj.transaction = t;
      } else {
        inWhereObj.transaction = t;
      }
    } else {
      inWhereObj.where = whereObj;
    }
    return this.model.update(setObj, inWhereObj);
  }
  async customExecAddOrPutSql(sql, paras = null) {
    return this.db.query(sql, paras);
  }
  /**
   * p.group.fields=['','']
   * p.group.sumField=''
   * p.group.aliasField=' as xxx'
   * @param {*} p
   */
  async statGroupBy(p, paras, t) {
    const groupFields = p.group.byFields.join(',');
    const aggField = p.group.aggField ? p.group.aggField : '';
    const tblName = p.group.tblName ? p.group.tblName : '';
    const where = p.group.where ? p.group.where : '';
    const having = p.group.having ? p.group.having : '';
    const aliasField = p.group.aliasField ? p.group.aliasField : '';
    const actionType = p.group.actionType ? p.group.actionType : 'count';
    const sql = `select ${groupFields},${actionType}(${aggField})  ${aliasField} from ${tblName}  ${where}  group by ${groupFields} ${having}  WITH ROLLUP`;
    return this.customQuery(sql, paras, t);
  }

  async customQuery(sql, paras, t) {
    let tmpParas = null;
    // ||paras=='undefined'?{type: this.db.QueryTypes.SELECT }:{ replacements: paras, type: this.db.QueryTypes.SELECT };
    if (t && t != 'undefined') {
      if (paras == null || paras == 'undefined') {
        tmpParas = { type: this.db.QueryTypes.SELECT };
        tmpParas.transaction = t;
      } else {
        tmpParas = { replacements: paras, type: this.db.QueryTypes.SELECT };
        tmpParas.transaction = t;
      }
    } else {
      tmpParas = paras == null || paras == 'undefined' ? { type: this.db.QueryTypes.SELECT } : { replacements: paras, type: this.db.QueryTypes.SELECT };
    }
    return this.db.query(sql, tmpParas);
  }
  async findCount(whereObj = null) {
    return this.model.count(whereObj, { logging: false }).then(c => c);
  }
  async findSum(fieldName, whereObj = null) {
    return this.model.sum(fieldName, whereObj);
  }
  async getPageList(pageIndex, pageSize, whereObj = null, orderObj = null, attributesObj = null, includeObj = null) {
    const tmpWhere = {};
    tmpWhere.limit = pageSize;
    tmpWhere.offset = (pageIndex - 1) * pageSize;
    if (whereObj != null) {
      tmpWhere.where = whereObj;
    }
    if (orderObj != null && orderObj.length > 0) {
      tmpWhere.order = orderObj;
    }
    if (attributesObj != null && attributesObj.length > 0) {
      tmpWhere.attributes = attributesObj;
    }
    if (includeObj != null && includeObj.length > 0) {
      tmpWhere.include = includeObj;
      tmpWhere.distinct = true;
    } else {
      tmpWhere.raw = true;
    }
    const result = await this.model.findAndCountAll(tmpWhere);
    return result;
  }
  async findOne(obj) {
    return this.model.findOne({ where: obj });
  }
  async findById(oid) {
    return this.model.findById(oid);
  }
}
module.exports = Dao;
