const system = require('../../../system');
const settings = require('../../../../config/settings');
const CtlBase = require('../../ctl.base');
const uuidv4 = require('uuid/v4');
class CachSearchesCtl extends CtlBase {
  constructor() {
    super('common', CtlBase.getServiceName(CachSearchesCtl));
  }
  async initNewInstance(queryobj, qobj) {
    return system.getResultSuccess({});
  }
  async findAndCountAll(pobj, gobj, req) {
    pobj.opCacheUrl = req.session.app.opCacheUrl;
    pobj.appid = req.appid;
    const result = await this.service.findAndCountAllCache(pobj);
    return result;
  }
  async delCache(queryobj, qobj, req) {
    const param = { key: queryobj.key, appid: req.appid, opCacheUrl: req.session.app.opCacheUrl };
    const result = await this.service.delCache(param);
    return result;
  }
  async clearAllCache(queryobj, qobj, req) {
    const param = { appid: req.appid, opCacheUrl: req.session.app.opCacheUrl };
    const result = await this.service.clearAllCache(param);
    return result;
  }
}
module.exports = CachSearchesCtl;
