const system = require('../../../system');
const http = require('http');
const querystring = require('querystring');
const settings = require('../../../../config/settings');
const CtlBase = require('../../ctl.base');
const moment = require('moment');
class MaterialCtl extends CtlBase {
  constructor() {
    super('bizchance', CtlBase.getServiceName(MaterialCtl));
  }

  /* 根据交付单id获取材料信息*/
  async findInfoByDeliverId(mobj, qobj, req) {
    const pobj = mobj.d;
    if (pobj.deliverId && pobj.deliverId != 'undefined') {
      try {
        const rs = await this.service.findInfoByDeliverId(pobj);
        const rarr = {};
        if (rs) {
          rarr.deliverId = rs.delivery_id;
          rarr.deliverNumber = rs.delivery_code;
          rarr.companyInfo = rs.company_info;
          rarr.registeredInfo = rs.registered_info;
          rarr.contributionInfo = rs.contribution_info;
          rarr.positionInfo = rs.position_info;
          rarr.regInfo = rs.file_info;
          rarr.expressInfo = rs.express_info;
        }
        return system.getResult(rarr);
      } catch (error) {
        return system.getResultError(error);
      }
    } else {
      return system.getResultError('参数错误！');
    }
  }

  /* 根据交付单id更新交付单编号信息*/
  async updateInfoByDeliverId(mobj, qobj, req) {
    const pobj = mobj.d;
    if (pobj.deliverId && pobj.deliverId != 'undefined' && pobj.deliverNumber && pobj.deliverNumber != 'undefined') {
      try {
        const res = await this.service.updateInfoByDeliverId(pobj);
        return system.getResult('更新成功！');
      } catch (error) {
        return system.getResultError(error);
      }
    } else {
      return system.getResultError('参数错误!');
    }
  }

  /* 插入缓存信息 */
  async insertInfo(mobj, qobj, req) {
    const pobj = mobj.d;
    if (pobj.deliverId && pobj.deliverId != 'undefined') {
      try {
        const res = await this.service.insertInfo(pobj);
        return system.getResult('插入成功！');
      } catch (error) {
        return system.getResultError(error);
      }
    } else {
      return system.getResultError('参数错误!');
    }
  }

  /* 获取待压缩文件的信息*/
  async waitGenerate() {
    try {
      const res = await this.service.findnoUrlInfo();
      if (res && res != 'undefined') {
        return system.getResult(res);
      }

      return system.getResultError('没有待压缩的数据');
    } catch (error) {
      return system.getResultError(error);
    }
  }

  /* 根据id更新zip信息 */
  async updateZipById(pobj, qobj, req) {
    console.log(`zip------------------${JSON.stringify(pobj)}`);
    if (pobj.id && pobj.id != 'undefined' && pobj.url && pobj.url != 'undefined') {
      try {
        await this.service.updateZipById(pobj);
        return system.getResult('更新压缩信息成功');
      } catch (error) {
        return system.getResultError(error);
      }
    } else {
      return system.getResultError('参数错误!');
    }
  }

  timeFormat(date) {
    let localTime = moment.utc(date).toDate();
    localTime = moment(localTime).format('YYYY-MM-DD');
    return localTime;
  }
}
module.exports = MaterialCtl;
// var task = new MaterialCtl();
// var obj={"id":2,"url":"http://test-1258715722.cos.ap-beijing.myqcloud.com/materials/90c263e0-b9d6-11ea-9e11-29abb292cf5f.png"};
// task.updateZipById(obj).then(d=>{
//   console.log(JSON.stringify(d));
//   //console.log(d[0].analyse);

// })
