const system = require('../../../system');
const http = require('http');
const querystring = require('querystring');
const settings = require('../../../../config/settings');
const CtlBase = require('../../ctl.base');
const moment = require('moment');
class CacheInfoCtl extends CtlBase {
  constructor() {
    super('bizchance', CtlBase.getServiceName(CacheInfoCtl));
    this.deliverService = system.getObject('service.bizchance.deliverybillSve');
  }

  /* 根据交付单id获取缓存详情*/
  async findInfoByDeliverId(mobj, qobj, req) {
    const pobj = mobj.d;
    if (pobj.deliverNumber && pobj.deliverNumber != 'undefined') {
      try {
        const rs = await this.service.findInfoByDeliverId(pobj);
        const divInfo = await this.deliverService.findInfoByDeliverCode(pobj);
        const rarr = {};
        if (rs && rs != 'undefined') {
          rarr.deliverNumber = rs.deliver_id;
          rarr.cacheInfo = rs.cache_info;
          if (rarr.cacheInfo && rarr.cacheInfo != 'undefined') {
            if (rarr.cacheInfo.cmpContactInfo.contactsPhone && rarr.cacheInfo.cmpContactInfo.contactsPhone != 'undefined') {
              rarr.cacheInfo.cmpContactInfo.contactsPhone = (
                system.decryptStr(rarr.cacheInfo.cmpContactInfo.contactsPhone)
              );
            }
            if (rarr.cacheInfo.positionData && rarr.cacheInfo.positionData.length > 0) {
              for (let i = 0; i < rarr.cacheInfo.positionData.length; i++) {
                if (rarr.cacheInfo.positionData[i].fixedPhone && rarr.cacheInfo.positionData[i].fixedPhone != 'undefined') {
                  rarr.cacheInfo.positionData[i].fixedPhone = (
                    system.decryptStr(rarr.cacheInfo.positionData[i].fixedPhone)
                  );
                }
                if (rarr.cacheInfo.positionData[i].mobilePhone && rarr.cacheInfo.positionData[i].mobilePhone != 'undefined') {
                  rarr.cacheInfo.positionData[i].mobilePhone = (
                    system.decryptStr(rarr.cacheInfo.positionData[i].mobilePhone)
                  );
                }
              }
            }
            if (rarr.cacheInfo.contributionData && rarr.cacheInfo.contributionData.length > 0) {
              for (let i = 0; i < rarr.cacheInfo.contributionData.length; i++) {
                if (rarr.cacheInfo.contributionData[i].phoneNumber && rarr.cacheInfo.contributionData[i].phoneNumber != 'undefined') {
                  rarr.cacheInfo.contributionData[i].phoneNumber = (
                    system.decryptStr(rarr.cacheInfo.contributionData[i].phoneNumber)
                  );
                }
                if (rarr.cacheInfo.contributionData[i].IdentificationNumber && rarr.cacheInfo.contributionData[i].IdentificationNumber != 'undefined') {
                  rarr.cacheInfo.contributionData[i].IdentificationNumber = (
                    system.decryptStr(rarr.cacheInfo.contributionData[i].IdentificationNumber)
                  );
                }
              }
            }
          }
          rarr.statusInfo = {};
          if (divInfo && divInfo != 'undefined') {
            rarr.statusInfo.deliverStatus = divInfo.delivery_status;// 状态
            rarr.statusInfo.statusReason = divInfo.close_reason;// 状态原因
            rarr.statusInfo.createdTime = this.timeFormat(divInfo.created_at);
            rarr.statusInfo.updateTime = this.timeFormat(divInfo.updated_at);
          }
        }

        return system.getResult(rarr);
      } catch (error) {
        return system.getResultError(error);
      }
    } else {
      return system.getResultError('参数错误！');
    }
  }

  /* 根据交付单id更新缓存信息*/
  async updateInfoByDeliverId(mobj, qobj, req) {
    const pobj = mobj.d;
    console.log(`cache---------------------------------------${JSON.stringify(pobj)}`);
    if (pobj.deliverNumber && pobj.deliverNumber != 'undefined' && pobj.cacheInfo && pobj.cacheInfo != 'undefined') {
      try {
        if (pobj.cacheInfo.cmpContactInfo && pobj.cacheInfo.cmpContactInfo != 'undefined') {
          if (pobj.cacheInfo.cmpContactInfo.contactsPhone && pobj.cacheInfo.cmpContactInfo.contactsPhone != 'undefined') {
            pobj.cacheInfo.cmpContactInfo.contactsPhone = (
              system.encryptStr(pobj.cacheInfo.cmpContactInfo.contactsPhone)
            );
          }
        }

        if (pobj.cacheInfo.positionData && pobj.cacheInfo.positionData.length > 0) {
          for (let i = 0; i < pobj.cacheInfo.positionData.length; i++) {
            if (pobj.cacheInfo.positionData[i].fixedPhone && pobj.cacheInfo.positionData[i].fixedPhone != 'undefined') {
              pobj.cacheInfo.positionData[i].fixedPhone = system.encryptStr(pobj.cacheInfo.positionData[i].fixedPhone);
            }
            if (pobj.cacheInfo.positionData[i].mobilePhone && pobj.cacheInfo.positionData[i].mobilePhone != 'undefined') {
              pobj.cacheInfo.positionData[i].mobilePhone = (
                system.encryptStr(pobj.cacheInfo.positionData[i].mobilePhone)
              );
            }
          }
        }
        if (pobj.cacheInfo.contributionData && pobj.cacheInfo.contributionData.length > 0) {
          for (let i = 0; i < pobj.cacheInfo.contributionData.length; i++) {
            if (pobj.cacheInfo.contributionData[i].phoneNumber && pobj.cacheInfo.contributionData[i].phoneNumber != 'undefined') {
              pobj.cacheInfo.contributionData[i].phoneNumber = (
                system.encryptStr(pobj.cacheInfo.contributionData[i].phoneNumber)
              );
            }
            if (pobj.cacheInfo.contributionData[i].IdentificationNumber && pobj.cacheInfo.contributionData[i].IdentificationNumber != 'undefined') {
              pobj.cacheInfo.contributionData[i].IdentificationNumber = (
                system.encryptStr(pobj.cacheInfo.contributionData[i].IdentificationNumber)
              );
            }
          }
        }
        const res = await this.service.updateInfoByDeliverId(pobj);
        return system.getResult('更新成功！');
      } catch (error) {
        console.log(`error----------------------------${error}`);
        return system.getResultError(error);
      }
    } else {
      console.log('-----------------------------------------参数错误');
      return system.getResultError('参数错误!');
    }
  }

  /* 插入或更新缓存信息 */
  async createInfo(mobj, qobj, req) {
    const pobj = mobj.d;
    if (pobj.deliverNumber && pobj.deliverNumber != 'undefined' && pobj.cacheInfo && pobj.cacheInfo != 'undefined') {
      try {
        if (pobj.cacheInfo.cmpContactInfo && pobj.cacheInfo.cmpContactInfo != 'undefined') {
          if (pobj.cacheInfo.cmpContactInfo.contactsPhone && pobj.cacheInfo.cmpContactInfo.contactsPhone != 'undefined') {
            pobj.cacheInfo.cmpContactInfo.contactsPhone = (
              system.encryptStr(pobj.cacheInfo.cmpContactInfo.contactsPhone)
            );
          }
        }

        if (pobj.cacheInfo.positionData && pobj.cacheInfo.positionData.length > 0) {
          for (let i = 0; i < pobj.cacheInfo.positionData.length; i++) {
            if (pobj.cacheInfo.positionData[i].fixedPhone && pobj.cacheInfo.positionData[i].fixedPhone != 'undefined') {
              pobj.cacheInfo.positionData[i].fixedPhone = system.encryptStr(pobj.cacheInfo.positionData[i].fixedPhone);
            }
            if (pobj.cacheInfo.positionData[i].mobilePhone && pobj.cacheInfo.positionData[i].mobilePhone != 'undefined') {
              pobj.cacheInfo.positionData[i].mobilePhone = (
                system.encryptStr(pobj.cacheInfo.positionData[i].mobilePhone)
              );
            }
          }
        }
        if (pobj.cacheInfo.contributionData && pobj.cacheInfo.contributionData.length > 0) {
          for (let i = 0; i < pobj.cacheInfo.contributionData.length; i++) {
            if (pobj.cacheInfo.contributionData[i].phoneNumber && pobj.cacheInfo.contributionData[i].phoneNumber != 'undefined') {
              pobj.cacheInfo.contributionData[i].phoneNumber = (
                system.encryptStr(pobj.cacheInfo.contributionData[i].phoneNumber)
              );
            }
            if (pobj.cacheInfo.contributionData[i].IdentificationNumber && pobj.cacheInfo.contributionData[i].IdentificationNumber != 'undefined') {
              pobj.cacheInfo.contributionData[i].IdentificationNumber = (
                system.encryptStr(pobj.cacheInfo.contributionData[i].IdentificationNumber)
              );
            }
          }
        }
        const rs = await this.service.findInfoByDeliverId(pobj);
        if (rs) {
          await this.service.updateInfoByDeliverId(pobj);
        } else {
          await this.service.insertInfo(pobj);
        }

        return system.getResult('操作成功！');
      } catch (error) {
        return system.getResultError(error);
      }
    } else {
      return system.getResultError('参数错误!');
    }
  }

  timeFormat(date) {
    let localTime = moment.utc(date).toDate();
    localTime = moment(localTime).format('YYYY-MM-DD');
    return localTime;
  }
}
module.exports = CacheInfoCtl;

// var task = new CacheInfoCtl();
// var obj={"demand_code":"30030302992","business_status":"isFinished"};
// task.updateStatusByDemandCode(obj,{},{}).then(d=>{
//   console.log(d);
//   //console.log(d[0].analyse);

// })
