const system = require('../../../system');
const http = require('http');
const querystring = require('querystring');
const settings = require('../../../../config/settings');
const CtlBase = require('../../ctl.base');
const logCtl = system.getObject('web.common.oplogCtl');
class DataauthCtl extends CtlBase {
  constructor() {
    super('auth', CtlBase.getServiceName(DataauthCtl));
  }
  async saveauth(qobj, querybij, req) {
    const { arys } = qobj;
    const { uid } = qobj;
    const refmodel = qobj.modelname;
    const u = await this.service.saveauth({
      user_id: uid,
      modelname: refmodel,
      auths: arys.join(','),
      app_id: req.appid,
    });
    return system.getResult(u);
  }
  async fetchInitAuth(qobj, querybij, req) {
    const { uid } = qobj;
    const refmodel = qobj.modelname;
    const authtmp = await this.service.findOne({ user_id: uid, modelname: refmodel, app_id: req.appid });
    if (authtmp) {
      const { auths } = authtmp;
      const arys = auths.split(',');
      return system.getResult(arys);
    }
    return system.getResultSuccess([]);
  }
}
module.exports = DataauthCtl;
