const APIBase = require('../../api.base');
const system = require('../../../system');
const settings = require('../../../../config/settings');
class RoleAuthAPI extends APIBase {
  constructor() {
    super();
    this.authS = system.getObject('service.auth.authSve');
  }
  async findAuthsByRole(p, q, req) {
    const tmpRoles = p.roles;
    const { appid } = p;
    const comid = p.companyid;
    const auths = await this.authS.findAuthsByRole(tmpRoles, appid, comid);
    return system.getResult(auths);
  }
  exam() {
    return `
      xxxxxxxxx
      yyyyyyyyy
      zzzzzzzzz
      ooooooo
      `;
  }
  classDesc() {
    return {
      groupName: 'auth',
      groupDesc: '角色授权相关的API',
      name: 'RoleAuthAPI',
      desc: '角色授权相关的API',
      exam: '',
    };
  }

  methodDescs() {
    return [
      {
        methodDesc: '按照角色获取权限，访问地址：/api/auth/roleAuth/findAuthsByRole',
        methodName: 'findAuthsByRole',
        paramdescs: [
          {
            paramDesc: '应用的ID',
            paramName: 'appid',
            paramType: 'int',
            defaultValue: 'x',
          },
          {
            paramDesc: '角色列表',
            paramName: 'roles',
            paramType: 'array',
            defaultValue: null,
          },
        ],
        rtnTypeDesc: '逗号分隔的',
        rtnType: 'string',
      },
    ];
  }
}
module.exports = RoleAuthAPI;
