[返回主目录](/doc)

<a name="menu">目录</a>
1. [登录接口有修改](#login)
1. [部门列表](#allOrg)
1. [部门树](#orgTree)
1. [部门详情](#orgById)
1. [新增部门](#orgSave)
1. [员工列表](#deliverUserPage)
1. [员工查询](#deliverUserById)
1. [员工保存](#deliverUserSave)

## **<a name="login"> 登录接口有修改</a>**
[返回到目录](#menu)
##### URL
[/web/uc/userCtl/login]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
|   参数   | 必选      |    类型   |      说明|
| -------- | -------- | ------------|---------|
| **loginName**  |  是     |  String     | 登录名|
| **password**  |  是    |  String     | 密码 |


#### 返回结果
```javascript

// 新增 auth 系统权限，isManager 是否管理员（管理员会显示公司管理）
{
    "status": 0,
    "msg": "success",
    "data": {
        "auth": [1, 2, 3, 4],                                   // 系统权限 1工商宝 2财务宝 3税务宝 4票据宝
        "isManager": true,                                      // 是否管理员
        "xggadminsid": "3cb49932-fa02-44f0-90db-9f06fe02e5c7"   // 登录key
        "menus": {
            "gtArr" : {}  //个体宝菜单
            "pjArr" : {}  //票据宝菜单
        }
    }
}

```

## **<a name="allOrg"> 部门列表</a>**
[返回到目录](#menu)
##### URL
[/web/common/deliverCtl/allOrg]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript
{}
```

#### 返回结果
```javascript
{
    "status": 0,
    "msg": "success",
    "data": [
        {
            "id": 2,                                        // id
            "name": "武汉交付商1",                           // 部门名称
            "path": "武汉交付商1.",                          // 部门路径   
            "created_at": "2020-02-11 11:05:48",
            "updated_at": "2020-02-11T12:13:58.000Z",
        },
    ],
    "requestid": "6c9f82cf594f404c81e8b0234edc323d"
}

```

## **<a name="orgTree"> 部门树</a>**
[返回到目录](#menu)
##### URL
[/web/common/deliverCtl/orgTree]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript
{}
```

#### 返回结果
```javascript
{
    "status": 0,
    "msg": "success",
    "data": [
        {
            "id": 2,                                        // id
            "name": "武汉交付商1",                           // 部门名称
            "path": "武汉交付商1.",                          // 部门路径   
            "created_at": "2020-02-11 11:05:48",
            "updated_at": "2020-02-11T12:13:58.000Z",
            "children": [                                   // 下级菜单
                {
                    "id": 2,                                        // id
                    "name": "武汉交付商1",                           // 部门名称
                    "path": "武汉交付商1.",                          // 部门路径   
                    "created_at": "2020-02-11 11:05:48",
                    "updated_at": "2020-02-11T12:13:58.000Z",
                    "children": []
                }
            ]
        }
    ],
    "requestid": "6c9f82cf594f404c81e8b0234edc323d"
}

```


## **<a name="orgById"> 部门详情</a>**
[返回到目录](#menu)
##### URL
[/web/common/deliverCtl/orgById]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript
{
    id: 3,  // 部门id
}
```

#### 返回结果
```javascript
{
    "status": 0,
    "msg": "success",
    "data": [
        {
            "id": 2,                                        // id
            "name": "武汉交付商1",                           // 部门名称
            "path": "武汉交付商1.",                          // 部门路径   
            "parent_id": 0,                                 // 部门父id
            "created_at": "2020-02-11 11:05:48",
            "updated_at": "2020-02-11T12:13:58.000Z",
        }
    ],
    "requestid": "6c9f82cf594f404c81e8b0234edc323d"
}

```



## **<a name="orgSave"> 新增部门</a>**
[返回到目录](#menu)
##### URL
[/web/common/deliverCtl/orgSave]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript

{
    "id": "",                   // id, 新增时为空，修改时不为空（原型上未发现修改）
    "parent_id": "2",           // 父id
    "name": "测试部123"         // 部门名称
}
```

#### 返回结果
```javascript
{
    "status": 0,
    "msg": "success",
    ],
    "requestid": "6c9f82cf594f404c81e8b0234edc323d"
}

```




## **<a name="deliverUserPage"> 员工列表</a>**
[返回到目录](#menu)
##### URL
[/web/common/deliverCtl/deliverUserPage]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript


{
    "currentPage": "1",
    "pageSize": "10",
    "org_id": "111"    // 组织机构id
}

```

#### 返回结果
```javascript
{
    "status": 0,
    "msg": "success",
    "data": {
        "count": 2,
        "rows": [
            {
                "id": 14,                                       // id
                "real_name": "韩老魔",                          // 姓名
                "ucname": "13333333333",                        // 登录账号
                "password": "",                                 // 密码
                "isAdmin": 0,                                   // 是否部门管理员 0否 1是
                "org_id": 3,                                    // 部门id
                "auth": [1, 2, 3, 4],                          // 拥有系统权限 1工商宝 2财务宝 3税务宝 4票据宝
                "created_at": "2020-02-21 06:57:57",            // 创建时间
                "updated_at": "2020-02-21T06:57:57.000Z",
                "deleted_at": null,
                "version": 0,
                "authNames": "工商宝、财务宝、税务宝、票据宝"  // 系统权限名称
            },
        ]
    },
    "requestid": "2d3e985fc95644b9b55b41336c903e78"
}

```






## **<a name="deliverUserById"> 员工查询</a>**
[返回到目录](#menu)
##### URL
[/web/common/deliverCtl/deliverUserById]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript


{
    "id": "1",
}

```

#### 返回结果
```javascript
{
    "status": 0,
    "msg": "success",
    "data": {
        "id": 14,                                       // id
        "real_name": "韩老魔",                          // 姓名
        "ucname": "13333333333",                        // 登录账号
        "password": "",                                 // 密码
        "isAdmin": 0,                                   // 是否部门管理员 0否 1是
        "org_id": 3,                                    // 部门id
        "auth": [1, 2, 3, 4],                          // 拥有系统权限 1工商宝 2财务宝 3税务宝 4票据宝
        "created_at": "2020-02-21 06:57:57",            // 创建时间
        "updated_at": "2020-02-21T06:57:57.000Z",
        "deleted_at": null,
        "version": 0,
        "authNames": "工商宝、财务宝、税务宝、票据宝"  // 系统权限名称
    },
    "requestid": "2d3e985fc95644b9b55b41336c903e78"
}

```


## **<a name="deliverUserSave"> 员工保存</a>**
[返回到目录](#menu)
##### URL
[/web/common/deliverCtl/deliverUserSave]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript



{
	"id": "",                           // 用户id
	"real_name": "韩老魔",              // 姓名
	"ucname": "13333333333",            // 登录名（限手机号）
	"org_id": "3",                      // 部门id
	"password": "123123",               // 密码
	"isAdmin": "0",                     // 是否部门管理员 0否 1是
	"auth": [1,2,3,4]                   // 系统权限 1工商宝 2财务宝 3税务宝 4票据宝
}

```

#### 返回结果
```javascript
{
    "status": 0,
    "msg": "success",
    "data": null,
    "requestid": "2d3e985fc95644b9b55b41336c903e78"
}

```