<a name="menu">目录</a>
1. [批量打款列表](#orderPage)
1. [上传数据](#parseItems)
1. [锁定批次](#lockOrder)
1. [付款申请](#offlinePay)
1. [查看详情](#orderInfo)
1. [交易列表](#itemPage)

## **<a name="orderPage"> 批量打款列表</a>**
[返回到目录](#menu)
##### URL
[/web/trade/tradeCtl/orderPage]

#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript
{
    "currentPage": "1",
    "pageSize": "10",
    "out_trade_no": "",             // 商户订单号
    "trade_status": "",             // 交易状态 00成功 01待处理 02失败 03部分成功
    "check_status": "",             // 审核状态 00待处理 01一审  02一审失败 03二审 04二审失败 05审核通过
    "createBegin": "",              // 创建时间-开始  可以只选开始，也可以只选结束，格式：2020-04-03
    "createEnd": ""                 // 创建时间-结束
}

```

#### 返回结果
```javascript

{
    "status": 0,
    "msg": "success",
    "data": {
        "count": 21,
        "rows": [
            {
                "id": "1298463038002876",                 // id
                "out_trade_no": "13695922219233720",      // 商户订单号
                "service_rate": 0,                        // 服务费比率     
                "created_at": "2020-04-02 14:16:21",      // 创建时间
                "item_count": 4,                          // 打款记录
                "amt": 131083.32,                         // 商户请求打款金额
                "actual_amt": 131083.32,                  // 实发金额
                "service_tax": 2621.66,                   // 服务费
                "deduct_amt": 128535.56,                  // 总扣款金额
                "check_status": "00",                     // 审核状态 00待处理 01一审 02一审失败 03二审 04二审失败 05二审通过
                "check_status_name": "待处理",            // 审核状态名称
                "trade_status": "01",                    // 打款状态 00成功 01待处理 02失败 03部分成功
                "trade_status_name": "待处理",           // 打款状态名称

                "pay_voucher": "",                       // 支付凭证图
                "acc_type": "00",                        // 打款通道
                "acc_type_name": "银行",                 // 打款通道名称
                "trade_mode": "00",                      // 打款模式 00未设置 01系统打款 02手工打款
                "trade_mode_name": "未设置",             // 打款模式名称
                "check1_remark": "",                     // 一审备注
                "check2_remark": "",                     // 二审备注

                "pay_bank_account": "111xxx",           // 订单付款账户名称
                "pay_bank_name": "1231234",             // 订单付款开户银行
                "pay_bank_no": "123456"                 // 订单付款银行账户
            }
        ]
    },
    "requestid": "09cd6abe34da475cb676b550ff9b282d"
}


```

## **<a name="parseItems"> 上传数据</a>**
[返回到目录](#menu)
##### URL
[/web/trade/tradeCtl/parseItems]

#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript

{
    "order_type": "10",         // 10批量上传 20交易上传
    // 上传文件地址
	"fileUrl": "https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_273315857206750512020113575551testbank2.xlsx"
}

```

#### 返回结果
```javascript

{
    "status": 0,
    "msg": "success",
    "data": {
        "order_type": "10",               // 10批量上传 20交易上传
        "actual_amt": "131083.32",        // 实发总额
        "deduct_amt": "133704.99",        // 扣除总额
        "service_tax": "2621.67",         // 服务费
        "error": false,                   // 上传文件是否有错误 false没有，true有错误
        "itemList": [
            {
                "errors": [               // 错误信息数组，多条，都在页面展示吧
                  "错误信息1",
                  "错误信息2",
                ],
                "acc_name": "11",                         // 收款户名
                "credit_code": "92321311MA205KN92J",      // 统一社会信用代码
                "acc_no": "3",                            // 收款账号
                "open_bank": "4",                         // 开户银行
                "amt": "5",                               // 请求打款金额
                "remark": "6",                            // 备注
                
                // ※※※※※※※※ 以下字段不允许编辑 ※※※※※※※※※※※
                "service_tax": "0.10",                    // 服务费
                "actual_amt": "5.00",                     // 实发金额
                "deduct_amt": "5.10"                      // 扣除金额
            },
        ]
    }
}

```


## **<a name="lockOrder"> 锁定批次</a>**
[返回到目录](#menu)
##### URL
[/web/trade/tradeCtl/lockOrder]

#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript

{
    "acc_type": "00",
    "order_type": "10",         // 10批量上传 20交易上传
    "fileUrl": "https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_273315857206750512020113575551testbank2.xlsx",
    "itemList": [
        {
            "errors": [               // 错误信息数组，多条，都在页面展示吧
              "错误信息1",
              "错误信息2",
            ],
            "acc_name": "11",                         // 收款户名
            "credit_code": "92321311MA205KN92J",      // 统一社会信用代码
            "acc_no": "3",                            // 收款账号
            "open_bank": "4",                         // 开户银行
            "open_bank": "4",                         // 开户银行
            "amt": "5",                               // 请求打款金额
            "remark": "6",                            // 备注
            
            // ※※※※※※※※ 以下字段不允许编辑 ※※※※※※※※※※※
            "service_tax": "0.10",                    // 服务费
            "actual_amt": "5.00",                     // 实发金额
            "deduct_amt": "5.10"                      // 扣除金额
        },
    ]
}

```

#### 返回结果
```javascript

{
    "status": 0,
    "msg": "操作成功",
    "data":  {
        "id": "1298533711001487",               // 订单id
        "out_trade_no": "13695851544002235",    // 商户订单号
        "amt": 131083.32,                       // 总请求打款金额
        "actual_amt": 131083.32,                // 总实发金额
        "deduct_amt": 128535.56,                // 总扣除金额        应付金额 X 元
        "service_tax": 2621.66,                 // 总服务费
        "item_count": 4,                        // 明细订单数量      总计 X 比交易
        "acc_type": "00",
        "pay_bank_account": "111xxx",           // 账户名称
        "pay_bank_name": "1231234",             // 开户银行
        "pay_bank_no": "123456"                 // 银行账户
    },
    "bizmsg": "empty"
}


```



## **<a name="offlinePay"> 付款申请</a>**
[返回到目录](#menu)
##### URL
[/web/trade/tradeCtl/offlinePay]

#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript

{
    "id": "1298475347002331",                   // 订单id，锁定批次时返回的id（列表中也有返回）
    "pay_voucher": "https://gsb........"        // 付款凭证
}

```

#### 返回结果
```javascript

{
    "status": 0,
    "msg": "success",
    "data": null,
    "requestid": "b46e1ff5176143ffa4135a357f93d757"
}


```


## **<a name="orderInfo"> 查看详情</a>**
[返回到目录](#menu)
##### URL
[/web/trade/tradeCtl/orderInfo]

#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript
{
    "id": "1",          // id
}

```

#### 返回结果
```javascript

{
    "status": 0,
    "msg": "success",
    "data": {
        "count": 21,
        "rows": [
            {
                "id": "1298463038002876",                 // id
                "merchant_name": "13695922219233720",     // 商户名称
                "out_trade_no": "13695922219233720",      // 商户订单号
                "service_rate": 0,                        // 服务费比率     
                "created_at": "2020-04-02 14:16:21",      // 创建时间
                "item_count": 4,                          // 打款记录
                "amt": 131083.32,                         // 商户请求打款金额
                "actual_amt": 131083.32,                  // 实发金额
                "service_tax": 2621.66,                   // 服务费
                "deduct_amt": 128535.56,                  // 总扣款金额
                "check_status": "00",                     // 审核状态 00待处理 01一审 02一审失败 03二审 04二审失败 05二审通过
                "check_status_name": "待处理",            // 审核状态名称
                "trade_status": "01",                    // 打款状态 00成功 01待处理 02失败 03部分成功
                "trade_status_name": "待处理",           // 打款状态名称

                "pay_voucher": "",                       // 支付凭证图
                "acc_type": "00",                        // 打款通道
                "acc_type_name": "银行",                 // 打款通道名称
                "trade_mode": "00",                      // 打款模式 00未设置 01系统打款 02手工打款
                "trade_mode_name": "未设置",             // 打款模式名称
                "check1_remark": "",                     // 一审备注
                "check2_remark": "",                     // 二审备注

                "pay_bank_account": "111xxx",           // 订单付款账户名称
                "pay_bank_name": "1231234",             // 订单付款开户银行
                "pay_bank_no": "123456"                 // 订单付款银行账户
            }
        ]
    },
    "requestid": "09cd6abe34da475cb676b550ff9b282d"
}


```


## **<a name="itemPage"> 交易列表</a>**
[返回到目录](#menu)
##### URL
[/web/trade/tradeCtl/itemPage]

#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript

{
    "currentPage": 1,
    "pageSize": 10,
    "out_trade_no": "",             // 商户订单号
    "acc_name": "",                 // 收款户名
    "acc_no": "",                   // 收款账户
    "credit_code": "",              // 信用代码
    "trade_status": "",             // 交易状态 00成功 01待处理 02失败
    "createBegin": "",              // 创建时间-开始  可以只选开始，也可以只选结束，格式：2020-04-03
    "createEnd": ""                 // 创建时间-结束
    "order_id": "1298534682000884", // 订单id，查订单详情时，使用这个字段过滤
}

```

#### 返回结果
```javascript

{
    "status": 0,
    "msg": "success",
    "data": {
        "count": 1493,
        "rows": [
            {
                "id": "1298463038002876",                 // id
                "trade_no": "T10014949456718",            // 打款编号
                "acc_name": "11",                         // 收款户名
                "acc_no": "3",                            // 收款账号
                "trade_status": "01",                     // 交易状态
                "trade_status_name": "待处理",            // 交易状态名称
                "trade_desc": "",                        // 交易描述
                "trade_receipt": "",                     // 回执图片，判断为空时不显示按钮
                "amt": 131083.32,                         // 商户请求打款金额
                "actual_amt": 131083.32,                  // 实发金额
                "service_tax": 2621.66,                   // 服务费
                "deduct_amt": 128535.56,                  // 总扣款金额
                "credit_code": "92321311MA205KN92J",      // 信用代码
                "out_trade_no": "13695922219233720",      // 商户订单号
                "created_at": "2020-04-03 11:38:19",      // 创建时间


                "order_id": "1298386120003945",           // 订单id
                "open_bank": "4",                         // 开户行全称
                "trade_time": null,                       // 交易时间
                "remark": "6",                            // 打款备注
                "service_rate": 0,                        // 服务费比率     
            }
        ]
    },
    "requestid": "d14ae10263ec45ab8cd3be23ab59faf2"
}
