<a name="menu">目录</a>
1. [交付商查看发票列表](#delivererInvoices)
1. [交付商查看发票审批列表](#delivererApplyInvoices)
1. [红冲列表](#redRushList)
1. [新建进度-已开具](#delivererAssignment)
1. [提交审核](#delivererAssignment2)
1. [新建进度-已邮寄](#delivererAssignment3)
1. [查看详情](#queryInvoiceDeliverer)



## **<a name="delivererInvoices"> 发票列表（交付商） </a>**　　　　　
[返回到目录](#menu)　　　　　

**接口方式** HTTP    
**HTTP方法** POST    
**URI路径** /web/invoice/invoiceCtl/delivererInvoices
**参数验证** 否     
**参数**    

| 参数名|数据类型|必须|默认| 说明 |
|---|:---:|:---:|:---:|---|

| pageIndex | number | 否 | 1　| 当前页数 |   
| pageSize | number | 否 | 10　| 每页记录数 |    
| invoiceTime | string | 否 | 　| 开发票时间 |    
| startTime | string | 否 | 　| 开发票开始时间 |    
| endTime | string | 否 | 　| 开发票结束时间 |    
| applyNo | string | 否 | 　| 发票申请编号 |  
| invoiceNo | string | 否 | 　| 发票编号 |  
| type | string | 否 | 　   | 发票类型 |    
| status | string | 否 | 　| 发票状态 |  


**返回结果**   

| 参数名|数据类型| 说明 |
|---|:---:|---|
| status | Number | 状态码 |
| msg | String | 提示信息 |
| data | JSON | 返回值 |

**示例**
```javascript
{
    "status": 0,
    "msg": "操作成功",
    "data": {
        "count": 1,
        "rows": [
            {
                "id": "11667778231000774",
                "apply_no": "gongsibao002",                                     //申请编号
                "type": "普通发票",                                              //发票状态
                "invoice_no": "gongsibao002",                                   //发票编号
                "invoice_time": "2019-11-27 00:00:00",                          //发票时间
                "invoice_amount": 20000000,                                     //发票金额
                "merchant_id": "18asf854584",                                   //购买方ID
                "merchant_name": "汉唐信通（咨询）有限公司",                        //购买方名称
                "merchant_credit_code": "911101057889696760",                   //购买方统一社会信用代码
                "merchant_addr": "北京市朝阳区来广营西路8号国创产业园6号楼三层东壹区",  //购买方地址
                "merchant_mobile": "010-8492",                                  //购买方电话
                "merchant_bank": "招商银大望路支行",                               //购买方银行
                "merchant_account": "tengxunkeji",                              //购买方账号
                "businessmen_id": "101",                                        //销售方ID
                "businessmen_credit_code": "91110108MA01H5F77N",                //销售方统一社会信用代码
                "businessmen_name": "滴滴出行",                                   //销售方名称
                "businessmen_addr": "北京市海淀区西北旺东路10号院东区2号楼二层202",    //销售方地址
                "businessmen_mobile": "010-5236",                                //销售方电话
                "businessmen_bank": "北京朝阳双秀支",                              //销售方电话
                "businessmen_account": "8569659856",                             //销售方账号
                "is_bank": 1,                                                    //是否开户
                "tax_authoritioes": "北京市工商行政管理局海淀分局",                   //授权机构
                "is_invalid": "2",                                               //是否红冲（已放弃）
                "complate_tax": "未完成",                                         //是否完税
                "status": "1080",                                                //发票状态
                "red_status": "未红冲",                                           //是否红冲
                "month": 11,                                                     //月份
                "statusName": "已邮寄"                                            //发票状态
            }
        ]
    },
    "bizmsg": "empty",
    "requestid": "93df11627c4a46628e801cb52c48bf85"
}

```

## **<a name="delivererApplyInvoices"> 发票申请列表（交付商） </a>**　　　　　
[返回到目录](#menu)　　　　　

**接口方式** HTTP    
**HTTP方法** POST    
**URI路径** /web/invoice/invoiceCtl/delivererApplyInvoices
**参数验证** 否     
**参数**    

| 参数名|数据类型|必须|默认| 说明 |
|---|:---:|:---:|:---:|---|
| pageIndex | number | 否 | 1　| 当前页数 |   
| pageSize | number | 否 | 10　| 每页记录数 |    
| invoiceTime | string | 否 | 　| 开发票时间 |    
| startTime | string | 否 | 　| 开发票开始时间 |    
| endTime | string | 否 | 　| 开发票结束时间 |    
| applyNo | string | 否 | 　| 发票申请编号 |    
| inInvalid | string | 否   | 　| 是否完税 |    
| type | string | 否 | 　   | 发票类型 |    
| status | string | 否 | 　| 发票状态 |    


**返回结果**   

| 参数名|数据类型| 说明 |
|---|:---:|---|
| status | Number | 状态码 |
| msg | String | 提示信息 |
| data | JSON | 返回值 |

**示例**

```javascript
{
    "status": 0,
    "msg": "操作成功",
    "data": {
        "count": 1,
        "rows": [
            {
                "id": "11667778231000774",
                "apply_no": "gongsibao002",                        //申请编号
                "type": "普通发票",                                 //发票类型
                "invoice_amount": 20000000,                        //发票金额 
                "invoice_time": "2019-09-19 00:00:00",             //发票时间
                "status": "1080",                                  //发票状态
                "merchant_name": "汉唐信通（咨询）有限公司",           //购买方名称
                "businessmen_name": "滴滴出行",                     //销售方名称
                "statusName": "已邮寄"                              //状态名称
            }
        ]
    },
    "bizmsg": "empty",
    "requestid": "3dc2b7a6d1f849d2bd1066ef180c5272"
}

```

## **<a name="redRushList"> 红冲列表） </a>**　　　　　
[返回到目录](#menu)　　　　　

**接口方式** HTTP    
**HTTP方法** POST    
**URI路径** /web/invoice/invoiceCtl/redRushList
**参数验证** 否     
**参数**    

| 参数名|数据类型|必须|默认| 说明 |
|---|:---:|:---:|:---:|---|
| pageIndex | number | 否 | 1　| 当前页数 |   
| pageSize | number | 否 | 10　| 每页记录数 |    
| invoiceTime | string | 否 | 　| 开发票时间 |    
| startTime | string | 否 | 　| 开发票开始时间 |    
| endTime | string | 否 | 　| 开发票结束时间 |    
| applyNo | string | 否 | 　| 发票申请编号 |    
| inInvalid | string | 否   | 　| 是否完税 |    
| type | string | 否 | 　   | 发票类型 |    
| status | string | 否 | 　| 发票状态  "1030": "待处理", "1040": "交付商关闭", "1050": "已开具", "1060": "待审核", "1080": "已邮寄", "1300": "审核失败(平台第二次审核)"|    
| redStatus | string | 否 | 　| 红冲状态 1：未红冲 2：红冲中 3 红冲失败 4 红冲成功 | 

**返回结果**   

| 参数名|数据类型| 说明 |
|---|:---:|---|
| status | Number | 状态码 |
| msg | String | 提示信息 |
| data | JSON | 返回值 |

**示例**

```javascript
{
    "status": 0,
    "msg": "操作成功",
    "data": {
        "count": 1,
        "rows": [
            {
                "id": "11667778231000774",
                "apply_no": "gongsibao002",                        //申请编号
                "type": "普通发票",                                 //发票类型
                "invoice_amount": 20000000,                        //发票金额 
                "invoice_time": "2019-09-19 00:00:00",             //发票时间
                "status": "1080",                                  //发票状态
                "merchant_name": "汉唐信通（咨询）有限公司",           //购买方名称
                "businessmen_name": "滴滴出行",                     //销售方名称
                "statusName": "已邮寄"                              //状态名称
            }
        ]
    },
    "bizmsg": "empty",
    "requestid": "3dc2b7a6d1f849d2bd1066ef180c5272"
}

```

## **<a name="delivererAssignment"> 新建进度-已开具</a>**　　　　　
[返回到目录](#menu)　　　　　

**接口方式** HTTP    
**HTTP方法** POST    
**URI路径** /web/invoice/invoiceCtl/delivererAssignment
**参数验证** 否     
**参数**    

| 参数名|数据类型|必须|默认| 说明 |
|---|:---:|:---:|:---:|---|
| id | string| 是 | 　| 发票申请ID |
| nextStatus | string | 是 |  1050　| 发票状态 |
| invoiceNo | string | 是 | 　| 发票编号 |
| invoiceTime | number | 是 |  　| 开具时间  |
| invoiceImg | string | 是 |  　| 发票图片  |

**示例** 

```
{
    "id":"11665430003004143",
    "nextStatus": "1050",
    "invoiceNo":"gongsibao4584585",
    "invoiceTime":"2019-10-12",
    "invoiceImg":"www.baidu.com"
}
```

**返回结果**   

| 参数名|数据类型| 说明 |
|---|:---:|---|
| status | Number | 状态码 |
| msg | String | 提示信息 |
| data | JSON | 返回值 |

**示例**

```javascript
{
    "status":0,
    "msg":"success",
    "data":null,
    "requestid":"3ea95f1837b9475da4a4d9aacc3ff74b"
}
```


## **<a name="delivererAssignment2"> 提交审核</a>**　　　　　
[返回到目录](#menu)　　　　　

**接口方式** HTTP    
**HTTP方法** POST    
**URI路径** /web/invoice/invoiceCtl/delivererAssignment
**参数验证** 否     
**参数**    

| 参数名|数据类型|必须|默认| 说明 |
|---|:---:|:---:|:---:|---|
| id | string| 是 | 　| 发票申请ID |
| nextStatus | string | 是 |  1060 　| 发票状态 |

**示例** 

```javascript
{
    "id":"11665033820002912",
	"nextStatus": "1060",
}
```

**返回结果**   

| 参数名|数据类型| 说明 |
|---|:---:|---|
| status | Number | 状态码 |
| msg | String | 提示信息 |
| data | JSON | 返回值 |

**示例**

```javascript
{
    "status":0,
    "msg":"success",
    "data":null,
    "requestid":"3ea95f1837b9475da4a4d9aacc3ff74b"
}
```

## **<a name="delivererAssignment3"> 交付商邮寄</a>**　　　　　
[返回到目录](#menu)　　　　　

**接口方式** HTTP    
**HTTP方法** POST    
**URI路径** /web/invoice/invoiceCtl/delivererAssignment
**参数验证** 否     
**参数**    

| 参数名|数据类型|必须|默认| 说明 |
|---|:---:|:---:|:---:|---|
| id | string| 是 | 　| 发票申请ID |
| nextStatus | string | 是 |  1080 　| 发票状态 |
| mailNo | string | 是 |  　| 邮寄单号 |

**示例** 

```
{
    "id":"11665430003004143",
    "nextStatus": "1080",
    "mailNo":"JIDNUId625815"
}
```

**返回结果**   

| 参数名|数据类型| 说明 |
|---|:---:|---|
| status | Number | 状态码 |
| msg | String | 提示信息 |
| data | JSON | 返回值 |

**示例**

```
{
    "status":0,
    "msg":"success",
    "data":null,
    "requestid":"3ea95f1837b9475da4a4d9aacc3ff74b"
}
```


## **<a name="queryInvoiceDeliverer"> 查看详情</a>**　　　　　
[返回到目录](#menu)　　　　　

**接口方式** HTTP    
**HTTP方法** POST    
**URI路径** '/api/op/action/springboard     
**参数验证** 否     
**参数**    

| 参数名|数据类型|必须|默认| 说明 |
|---|:---:|:---:|:---:|---|
| id | string | 否 | 　| 发票ID |
| applyNo | string | 否 | 　| 发票申请号   |
| merchantId | string | 是 | 　| 商户ID  |


**示例**
```
注意：applyNo结合merchantId 一起使用，当id存在是优先使用Id查询
{
	"merchantId":"11665033820002912",
	"applyNo": "1020",
	"id":"xxxx"
}
```


**返回结果**   

| 参数名|数据类型| 说明 |
|---|:---:|---|
| status | Number | 状态码 |
| msg | String | 提示信息 |
| data | JSON | 返回值 |

**示例**
```
{
    "status":0,
    "msg":"操作成功",
    "data":{
        "id":"11665033820002912",
        "delivererId":"11329678846003516",
        "merchantId":"18asf854584",
        "merchantName":"腾讯信息科有限公司",
        "merchantCreditCode":"5456461654165",
        "merchantAddr":"北京海淀区上地",
        "merchantMobile":"18833836392",
        "merchantBank":"招商银大望路支行",
        "merchantAccount":"tengxunkeji",
        "businessmenId":"12795594625000138",
        "businessmenCreditCode":"91210200MA0QE7GT5L",
        "businessName":"网易信息科技",
        "isBank":"未开户",
        "taxAuthorities":"北京朝阳税务局",
        "type":"普通发票",
        "invoiceAmount":20000000,
        "statements":"wwww.baidu.com",
        "contract":"www.qq.com",
        "invoiceTime":"2019-09-19",
        "settleImg":"www.taobao.com",
        "applyNo":"gongsibao001",
        "invoiceContent":null,
        "personalIncomeTax":48292651,
        "additionalTax":6532390,
        "valueAddedTax":54436581,
        "serviceCharge":4500,
        "applyMobile":null,
        "mailAddr":"北京来广营",
        "mailMobile":"0-012535",
        "mailTo":"脚姐",
        "createdAt":"2019-10-25",
        "deliverer":{
            "auditContent":"审核内容信息",
            "delivererContent":"交付商交付内容信息",
            "mailAddr":"北京大望路",
            "mailMobile":"1000",
            "mailTo":"脚姐",
            "delivererMailNo":"JIDNUId625815",
            "status":"1080",
            "statusName":"已邮寄"
        },
        "invoice":{
            "invoiceNo":"gongsibao4584585",
            "invoiceTime":"2019-10-12",
            "invoiceImg":"www.baidu.com",
            "taxNo":"DIE552SDKD",
            "complateTax":"已完税",
            "taxTime":"2019-10-10",
            "taxVoucher":null
        }
    },
    "bizmsg":"empty",
    "requestid":"eecdd1283154468897f30b0c2fd37cb3"
}
```



