const system = require("../system");

class Validation {
  constructor() {
    // this.restClient = system.getObject("util.restClient");
    this.PATTERN = {
      EMAIL_PATTERN: /^\w+((-\w+)|(\.\w+))*\@[A-Za-z0-9]+((\.|-)[A-Za-z0-9]+)*\.[A-Za-z0-9]+$/,
      PHONE_PATTERN: /^(1[0-9])\d{9}$/,
      CHINESE_PATTERN: /^[\u4E00-\u9FA5]+$/,
      ENGLISH_PATTERN: /^[A-Za-z]+$/,
      QQ_PATTERN: /^[1-9][0-9]{4,}$/,
      NUMBER_PATTERN: /^\d+$/,
      CONTAINS_CHINESE_PATTERN: /[\u4e00-\u9fa5]/,
      CONTAINS_ENGLISH_PATTERN: /.*[a-zA-Z]+.*/,
      CONTAINS_NUM_PATTERN: /[0-9]+?/,
      DATE_PATTERN: /((^((1[8-9]\d{2})|([2-9]\d{3}))[-](10|12|0?[13578])[-](3[01]|[12][0-9]|0?[1-9])(\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^((1[8-9]\d{2})|([2-9]\d{3}))[-](11|0?[469])[-](30|[12][0-9]|0?[1-9])(\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^((1[8-9]\d{2})|([2-9]\d{3}))[-](0?2)[-](2[0-8]|1[0-9]|0?[1-9])(\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^([2468][048]00)[-](0?2)[-](29)(\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^([3579][26]00)[-](0?2)[-](29)(\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^([1][89][0][48])[-](0?2)[-](29)(\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^([2-9][0-9][0][48])[-](0?2)[-](29)(\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^([1][89][2468][048])[-](0?2)[-](29)(\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^([2-9][0-9][2468][048])[-](0?2)[-](29)(\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^([1][89][13579][26])[-](0?2)[-](29)(\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^([2-9][0-9][13579][26])[-](0?2)[-](29)(\s{1}([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$)|(^([2-9][0-9][13579][26])[-](0?2)[-](29)(\s{1}([this.01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9](\.[0-9]*))?$))/,
      PASSWORD_PATTERN: /^(?![0-9]+$)(?![a-zA-Z]+$)[0-9A-Za-z]{6,20}$/,
    };
  }

  isMobile(mobile) {
    if (!mobile) {
      return false;
    }
    return !this.PATTERN.PHONE_PATTERN.test(mobile);
  }

  /**
   * 验证字段合法
   * @param data 验证的对象
   *        data.errors 数组，不为空时，会将验证数据放到数组中
   * @param field 验证的key
   * @param rule 验证规则
   * @param vall 是否全部验证完成
   * @returns
   */
  check(data, field, rule) {
    if (!rule) {
      return true;
    }
    if(!data) {
      throw new Error(msg + "对象不存在");
    }
    let v = data[field];
    if (rule.is_require && !v) {
      this.error(data, `${rule.name}：为空`);
    }
    if (rule.maxLen && v.length > rule.maxLen) {
      this.error(data, `${rule.name}：长度不允许超过${rule.maxLen}`);
    }
    if (rule.minLen && v.length < rule.minLen) {
      this.error(data, `${rule.name}：长度不允许少于${rule.minLen}`);
    }
    if (rule.eqLen && v.length != rule.eqLen) {
      this.error(data, `${rule.name}：长度为${rule.eqLen}`);
    }
    if (rule.is_number && isNaN(v)) {
      this.error(data, `${rule.name}：需要填写数字类型`);
    }
    if (rule.is_mobile && this.PATTERN.PHONE_PATTERN.test(v)) {
      this.error(data, `${rule.name}：格式错误`);
    }
    if (rule.dics && rule.dics.indexOf(v) == -1) {
      this.error(data, `${rule.name}：${v} 错误`);
    }
    if(rule.arr_require && (!v || v.length == 0)) {
      this.error(data, `${rule.name}：数据为空`);
    }
  }

  error(data, msg) {
    if(data.errors) {
      data.errors.push(msg);
    } else {
      throw new Error(`bpo-validation-error:${msg}`);
    }
  }
}

module.exports = Validation;
