const system = require("../../../system");
const ServiceBase = require("../../svems.base")

class UserService extends ServiceBase {
  constructor() {
    super();
  }

  async login(params) {
    try {
      return await this.callms("uc", "merchantLogin", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }
  
  async info(params) {
    try {
      return await this.callms("uc", "merchantInfo", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }
  
  async mapByIds(params) {
    try {
      return await this.callms("uc", "merchantMapByIds", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }
}

module.exports = UserService;