const system = require("../../../system");
const ServiceBase = require("../../svems.base")
class SaasService extends ServiceBase {
  constructor() {
    super();
  }

  /**
   * saas  添加 
   * @param {*} params 
   */
  async addSaas(params) {
    try {
      return await this.callms("uc", "addSaas", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * saas  更新
   * @param {*} params 
   */
  async updSaas(params) {
    try {
      return await this.callms("uc", "updSaas", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * saas 删除 
   * @param {*} params 
   */
  async delSaas(params) {
    try {
      return await this.callms("uc", "delSaas", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }
  /**
   * saas  查询列表 
   * @param {*} params 
   */
  async listSaas(params) {
    try {
      return await this.callms("uc", "listSaas", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * saas  查询明细
   * @param {*} params 
   */
  async queryById(params) {
    try {
      return await this.callms("uc", "orgQuery", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }
}
module.exports = SaasService;