const system = require("../../../system");
const ServiceBase = require("../../svems.base")
const settings = require("../../../../config/settings");
const axios = require("axios");
class TaxService extends ServiceBase {
  constructor() {
    super();
  }
  /**
   * 月账期
   * @param {*} params 
   */
  async getReportData(params) {
    try {
      let data ={
        "accountPeriod": this.trim(params.accountPeriod),
        "companyId": this.trim(params.companyId),
        "customerId": this.trim(params.customerId),
        "desc": this.trim(params.desc) || "string",
        "reportType":this.trim(params.reportType) || 2,
        "signWithoutKey": this.trim(params.signWithoutKey)|| "string"
      }
      let url = settings.ntapi().getReportData;
      return await this.callApi(url, data, "月账期");
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * 季度账期
   * @param {*} params 
   */
  async getReportDataQuarter(params) {
    try {
      let data ={
        "companyId": this.trim(params.companyId),
        "customerId": this.trim(params.customerId),
        "desc": this.trim(params.desc) || "string",
        "reportType":this.trim(params.reportType) || 2,
        "signWithoutKey": this.trim(params.signWithoutKey)|| "string",
        "endPeriod": this.trim(params.endPeriod),
        "startPeriod": this.trim(params.startPeriod)
      }
      let url = settings.ntapi().getReportDataQuarter;
      return await this.callApi(url, params, "季度账期");
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * 获取用户账簿信息
   * @param {*} params 
   * id  个体工商户ID
   */
  async getCustomerById(params) {
    try {
      let customer_id = this.trim(params.customer_id);
      // let businessmen = await axios({
      //   method: 'post',
      //   url: settings.deliverSysApi().info,
      //   data: {id: params.id}
      // });
      // if (businessmen.status=!200 || businessmen.data.status!=0 || !businessmen.data.data.customer_id) {
      //   return system.getResult(null, `个体工商户不存在`);
      // }
      let url = settings.ntapi().getCustomerById;
      let res = await this.callApi(url, {
        // id: businessmen.data.data.customer_id
        id: customer_id
      }, "获取用户账簿信息");
      return res;
    } catch (error) {
      console.log(error);
      return system.getResult(null, `系统错误`);
    }
  }

  /**
   * 获取工商户列表
   * @param {*} params 
   */
  // async businessmenPage(params) {

  //   try {
  //     let businessmen = await axios({
  //       method: 'post',
  //       url: settings.deliverSysApi().businessmenPage,
  //       data: {id: params.id}
  //     });
  //     if (businessmen.status=!200 || businessmen.data.status!=0 ) {
  //       return system.getResult(null, `系统错误`);
  //     }

  //     let url = settings.ntapi().getCustomerById;
  //     let res = await this.callApi(url, {
  //       id: businessmen.data.data.customer_id
  //     }, "获取用户账簿信息");
  //     return res;
  //   } catch (error) {
  //     console.log(error);
  //     return system.getResult(null, `系统错误`);
  //   }
  // }


  


}
module.exports = TaxService;