const system = require("../../../system");
const ServiceBase = require("../../svems.base")
const settings = require("../../../../config/settings")
class OrderService extends ServiceBase {
  constructor() {
    super();
  }

  async microAdd(params) {
    let rs = await this.callms("order", "saasOrderMicroAdd", params);
    return rs;
  }

  async orderInfo(params) {
    let rs = await this.callms("order", "saasOrderInfo", params);
    return rs;
  }

  async info(params) {
    let rs = await this.callms("order", "saasOrderMerchantOrderInfo", params);
    return rs;
  }

  async offlinePay(params) {
    let rs = await this.callms("order", "saasOrderBulkOfflinePay", params);
    return rs;
  }

  async page(params) {
    let rs = await this.callms("order", "saasOrderPage", params);
    if (rs && rs.data && rs.data.rows) {
      this.transOrderField(rs.data.rows);
    }
    return rs;
  }

  async mapByIds(params) {
    let rs = await this.callms("order", "saasOrderMapByIds", params) || {};
    return rs.data || {};
  }

  // 交付信息 map by 信用代码
  async mapByCreditCodes(params) {
    let rs = await this.callms("order", "saasBusinessmenMapByCreditCodes", params);
    if(!rs || !rs.data) {
      return {};
    }
    return rs.data;
  }
  async businessmenPage(params) {
    let rs = await this.callms("order", "saasOrderDeliverBusinessmenPage", params) || {};
    return rs;
  }

  transOrderField(rows) {
    if (!rows || rows.length == 0) {
      return;
    }

    for (let row of rows) {
      row.price = system.f2y(row.price);
    }
  }
  async byIds(params) {
    let rs = await this.callms("order", "itemByIds", params);
    return rs;
  }

  async updateInvoice(params) {
    let rs = await this.callms("order", "updateItemInvoice", params);
    return rs;
  }

}
module.exports = OrderService;