const system = require("../../../system");
const ServiceBase = require("../../svems.base")
const settings = require("../../../../config/settings")

class BusinessmenService extends ServiceBase {
  constructor() {
    super();
  }
  async allPage(params) {
    let rs = await this.callms("order", "businessmenPage", params);
    if (rs.status != 0 || !rs.data || !rs.data.rows) {
      return rs;
    }
    this.transField(rs.data.rows);
    return rs;
  }

  async mapByCreditCodes(params) {
    let rs = await this.callms("order", "businessmenMapByCreditCodes", params);
    if(!rs || !rs.data) {
      return {};
    }
    return rs.data;
  }


  transField(rows) {
    if (!rows) {
      return;
    }

    for (var row of rows) {
      row.costRate = system.f2y(row.costRate);
      row.taxRate = system.f2y(row.taxRate);
      row.serviceRate = system.f2y(row.serviceRate);
      row.serviceBeginTime = system.f2y(row.serviceRate);
      row.serviceRate = system.f2y(row.serviceRate);
      this.handleDate(row, ["service_begin_time", "service_end_time", "tax_reg_day", "reg_date", "sign_time"], "YYYY-MM-DD", -8);
      this.parseJsonField(row, ["common_tax_ladder", "common_other_ladder", "special_tax_ladder", "special_other_ladder"]);
    }
  }

  parseJsonField(row, fields) {
    if (!row || !fields || fields.length == 0) {
      return;
    }
    for (var f of fields) {
      if (!f) {
        continue;
      }
      if (!row[f]) {
        row[f] = [];
        continue;
      }
      try {
        row[f] = JSON.parse(row[f]);
      } catch (error) {
        console.log(error);
      }
    }
  }
}

module.exports = BusinessmenService;
// var task=new UserService();
// task.getUserStatisticGroupByApp().then(function(result){
//   console.log((result));
// }).catch(function(e){
//   console.log(e);
// });