var system = require("../../../system")
const settings = require("../../../../config/settings")
const CtlBase = require("../../ctlms.base");
const md5 = require("MD5");
const uuidv4 = require('uuid/v4');
const logCtl = system.getObject("web.common.oplogCtl");

class UserCtl extends CtlBase {
  constructor() {
    super();
    this.userSve = system.getObject("service.uc.userSve");
    this.redisClient = system.getObject("util.redisClient");
    this.captchaSve = system.getObject("service.common.captchaSve");
    this.deliverSve = system.getObject("service.common.deliverSve");
    this.merchantCtl = system.getObject("service.saas.merchantSve");
  }

  async login(pobj, pobj2, req, res) {
    var loginName = this.trim(pobj.loginName);
    var password = this.trim(pobj.password);
    try {
      var loginUser = await this.userSve.login({
        ucname: loginName,
        password: password,
      });
      if (loginUser.status != 0) {
        return loginUser;
      }

      loginUser = loginUser.data;

      let channel = await this.merchantCtl.info({id:loginUser.saas_merchant_id});
      if (channel.status != 0) {
        return system.getResult(null, `渠道【${loginName}】不存在`);
      }
      channel = channel.data;
      loginUser.contact_man = channel.contact_man;
      loginUser.contact_mobile = channel.contact_mobile;
      loginUser.contact_email = channel.contact_email;
      loginUser.contact_addr = channel.contact_addr;

      var loginsid = await this.setLogin(loginUser);
      let rs = {
        key: loginsid,
        loginname: loginUser.ucname,
        menus: await this.getMenu(loginUser)
      };

      return system.getResultSuccess(rs);
    } catch (error) {
      console.log(error);
      return system.getResultFail(500, "接口异常：" + error.message);
    }
  }

  async setLogin(user) {
    let loginsid = "saasmcth_" + uuidv4();
    // if (settings.env = "dev") {
    //   loginsid = "saasmcth_" + "2cb49932-fa02-44f0-90db-9f06fe02e5c7";
    // }
    await this.redisClient.setWithEx(loginsid, JSON.stringify(user), 60 * 60 * 5);
    return loginsid;
  }

  getMenu(loginUser) {
    if (!loginUser) {
      return [];
    }
    return [{
        "name": "数据概览",
        "icon": "iconfont icon-gth-gsshujugailan",
        "team": [{
          "name": "业务数据汇总",
          "path": "/home"
        }]
      },
      {
        "name": "订单中心",
        "icon": "iconfont icon-gth-gsdingdanzhongxin",
        "team": [{
          "name": "订单管理",
          "path": "/trading/ordersAll"
        }, ]
      },
      {
        "name": "个体户中心",
        "icon": "iconfont icon-gth-gsgetihuzhongxin",
        "team": [{
          "name": "个体户管理",
          "path": "/trading/userInformation"
        }, ]
      },
    ];
  }

  async currentUser(qobj, pobj, req) {
    return system.getResultSuccess(req.loginUser);
  }

  /**
   * 启用禁用
   * @param {*} params
   * @param {*} pobj2
   * @param {*} req
   */
  async enabled(params, pobj2, req) {
    try {
      params.id = Number(params.id || 0);
      params.enabled = Number(params.enabled || 0);
      return await this.userSve.enabled(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async delUser(params, pobj2, req) {
    try {
      return await this.userSve.delUser(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   *   查询明细
   * @param {*} params
   */
  async queryById(params, pobj2, req) {
    try {
      return await this.userSve.queryById(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async updPassword(params, pobj2, req) {
    params.password = this.trim(params.password);
    if (!params.password) {
      return system.getResult(null, `请填写密码`);
    }

    try {
      return await this.userSve.updPassword(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * 根据pid查出子目录
   * @param {*} params
   */
  async page(params, pobj2, req) {
    try {
      params.uctypeId = params.deliver_id;
      return await this.userSve.page(params);
    } catch (error) {
      console.log(error);
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async salesmanList(params, pobj2, req) {
    try {
      if (!params.deliver_id) {
        return system.getResultSuccess([]);
      }
      return await this.userSve.salesmanList(params);
    } catch (error) {
      console.log(error);
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }
}

module.exports = UserCtl;