var system = require("../../../system")
const CtlBase = require("../../ctlms.base");
class SaasCtl extends CtlBase {
  constructor() {
    super();
    this.saasSve = system.getObject("service.uc.saasSve");
  }

    /**
   * saas  添加 
   * @param {*} params 
   */
  async addSaas(params, pobj2, req) {
    try {
      return await this.saasSve.addSaas(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * saas  更新
   * @param {*} params 
   */
  async updSaas(params, pobj2, req) {
    try {
      return await this.saasSve.updSaas(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * saas 删除 
   * @param {*} params 
   */
  async delSaas(params, pobj2, req) {
    try {
      return await this.saasSve.delSaas(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }
  /**
   * saas  查询列表 
   * @param {*} params 
   */
  async listSaas(params, pobj2, req) {
    try {
      return await this.saasSve.listSaas(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * saas  查询明细
   * @param {*} params 
   */
  async queryById(params, pobj2, req) {
    try {
      return await this.saasSve.queryById(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

}
module.exports = SaasCtl;