var system = require("../../../system")
const CtlBase = require("../../ctlms.base");

class TradeCtl extends CtlBase {
  constructor() {
    super();
    this.tradeSve = system.getObject("service.trade.tradeSve");
    this.redisClient = system.getObject("util.redisClient");
  }

  async orderPage(params, pobj2, req) {
    try {
      this.doTimeCondition(params, ["createBegin", "createEnd"]);
      return await this.tradeSve.orderPage(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async parseItems(params, pobj2, req) {
    try {
      params.fileName = req.loginUser.id;
      return await this.tradeSve.parseItems(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async orderInfo(params, pobj2, req) {
    try {
      return await this.tradeSve.orderInfo(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async lockOrder(params, pobj2, req) {
    try {
      return await this.tradeSve.lockOrder(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async offlinePay(params, pobj2, req) {
    try {
      return await this.tradeSve.offlinePay(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async itemPage(params, pobj2, req) {
    try {
      this.doTimeCondition(params, ["createBegin", "createEnd"]);
      return await this.tradeSve.itemPage(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }
}

module.exports = TradeCtl;