var system = require("../../../system")
const CtlBase = require("../../ctlms.base");

class TaxCtl extends CtlBase {
  constructor() {
    super();
    this.taxSve = system.getObject("service.tax.taxSve");
    this.orderSve = system.getObject("service.saas.orderSve");
    this.redisClient = system.getObject("util.redisClient");
  }

  /**
   * 月账期
   * @param {*} params
   */
  async getReportData(params) {
    try {
      let res = await this.taxSve.getReportData(params);
      return system.getResult(res);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * 季度账期
   * @param {*} params
   */
  async getReportDataQuarter(params) {
    try {
      let res = await this.taxSve.getReportDataQuarter(params);
      return system.getResult(res);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }


  /**
   * 获取账簿用户信息
   * @param {*} pobj
   * @param {*} pobj2
   * @param {*} req
   * @id
   */
  async getCustomerById(pobj, pobj2, req) {
    try {
      // if (!pobj.id) {
      //   return system.getResult(null, `参数错误 ID 不能为空`);
      // }
      let res = await this.taxSve.getCustomerById(pobj);
      return res;
    } catch (error) {
      console.log(error);
      return system.getResult(error);
    }
  }

  async businessmenPage(pobj, pobj2, req) {
    try {
      let res = await this.orderSve.businessmenPage(pobj);
      return res;
    } catch (error) {
      console.log(error);
      return system.getResult(error);
    }
  }
}

module.exports = TaxCtl;