var system = require("../../../system")
const CtlBase = require("../../ctlms.base");
class ManagerCtl extends CtlBase {
  constructor() {
    super();
    this.invoiceSve = system.getObject("service.invoice.invoiceSve");
  }

  /**
   * 交易数据(平台)
   * @param {*} pobj 
   */
  async transData(pobj, pobj2, req) {
    try {
      var params = {
        type: pobj.type || 1,
      };
      // 交易数据
      return await this.invoiceSve.statManageData(params);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  /**
   * 首页业务数据(平台)
   * @param {*} pobj 
   */
  async businessData(pobj, pobj2, req) {
    try {
      var params = {
        type: pobj.type || 1,
      };
      // 业务数据
      return await this.invoiceSve.statBusinessData(params);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

    /**
   * 首页交易数据（交付商）
   * @param {*} pobj 
   */
  async delTransData(pobj, pobj2, req) {
    try {
      var params = {
        type: pobj.type || 1,
        delivererId:this.trim(pobj.delivererId)
      };
      // 交易数据
      return await this.invoiceSve.delStatManageData(params);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  /**
   * 首页业务数据（交付商）
   * @param {*} pobj 
   */
  async delBusinessData(pobj, pobj2, req) {
    try {
      var params = {
        type: pobj.type || 1,
        delivererId:this.trim(pobj.delivererId)
      };
      // 业务数据
      return await this.invoiceSve.delStatBusinessData(params);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }
  //业务概览 （平台）
  async deliverData(pobj, pobj2, req) {
    try {
      var params = {
        type: pobj.type || 1,
        currentPage: pobj.currentPage || 1,
        pageSize: pobj.pageSize || 10,
      }
      // 业务办理概览
      return await this.invoiceSve.statDeliverData(params);

    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }
}
module.exports = ManagerCtl;