var system = require("../../../system")
var settings = require("../../../../config/settings");
const CtlBase = require("../../ctlms.base");
const uuidv4 = require('uuid/v4');
var moment = require("moment");
var svgCaptcha = require('svg-captcha');

class DomicileCtl extends CtlBase {
  constructor() {
    super();
    //this.appS=system.getObject("service.appSve");
    this.domicileSve = system.getObject("service.common.domicileSve");
  }

  async nameList(pobj, pobj2, req) {
    try {
      return await this.domicileSve.nameList(pobj);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  async all(pobj, pobj2, req) {
    try {
      return await this.domicileSve.tree(pobj);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  async page(pobj, pobj2, req) {
    try {
      return await this.domicileSve.page(pobj);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  async info(pobj, pobj2, req) {
    try {
      return await this.domicileSve.info(pobj);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  async save(pobj, pobj2, req) {
    try {
      return await this.domicileSve.save(pobj);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  async del(pobj, pobj2, req) {
    try {
      return await this.domicileSve.del(pobj);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }
}
module.exports = DomicileCtl;