const system = require("../system");
const settings = require("../../config/settings");
class CtlBase {
  constructor(gname, sname) {
    this.serviceName = sname;
    this.service = system.getObject("service." + gname + "." + sname);
    this.cacheManager = system.getObject("db.common.cacheManager");
    this.md5 = require("MD5");
  }
  encryptPasswd(passwd) {
    if (!passwd) {
      throw new Error("请输入密码");
    }
    var md5 = this.md5(passwd + "_" + settings.salt);
    return md5.toString().toLowerCase();
  }
  notify(req, msg) {
    if (req.session) {
      req.session.bizmsg = msg;
    }
  }
  async findOne(queryobj, qobj) {
    var rd = await this.service.findOne(qobj);
    return system.getResult(rd, null);
  }
  async findAndCountAll(queryobj, obj, req) {
    obj.codepath = req.codepath;

    if (req.session.user) {
      obj.uid = req.session.user.id;
      obj.appid = req.session.user.app_id;
      obj.onlyCode = req.session.user.unionId;
      obj.account_id = req.session.user.account_id;
      obj.ukstr = req.session.user.app_id + "￥" + req.session.user.id + "￥" + req.session.user.nickName + "￥" + req.session.user.headUrl;
    }
    var apps = await this.service.findAndCountAll(obj);
    return system.getResult(apps, null);
  }
  async refQuery(queryobj, qobj) {
    var rd = await this.service.refQuery(qobj);
    return system.getResult(rd, null);
  }
  async bulkDelete(queryobj, ids) {
    var rd = await this.service.bulkDelete(ids);
    return system.getResult(rd, null);
  }
  async delete(queryobj, qobj) {
    var rd = await this.service.delete(qobj);
    return system.getResult(rd, null);
  }
  async create(queryobj, qobj, req) {
    if (req && req.session && req.session.app) {
      qobj.app_id = req.session.app.id;
      qobj.onlyCode = req.session.user.unionId;
      if (req.codepath) {
        qobj.codepath = req.codepath;
      }
    }
    var rd = await this.service.create(qobj);
    return system.getResult(rd, null);
  }
  async update(queryobj, qobj, req) {
    if (req && req.session && req.session.user) {
      qobj.onlyCode = req.session.user.unionId;
    }
    if (req.codepath) {
      qobj.codepath = req.codepath;
    }
    var rd = await this.service.update(qobj);
    return system.getResult(rd, null);
  }
  static getServiceName(ClassObj) {

    return ClassObj["name"].substring(0, ClassObj["name"].lastIndexOf("Ctl")).toLowerCase() + "Sve";
  }
  async initNewInstance(queryobj, req) {
    return system.getResult({}, null);
  }
  async findById(oid) {
    var rd = await this.service.findById(oid);
    return system.getResult(rd, null);
  }
  async timestampConvertDate(time) {
    if (time == null) {
      return "";
    }
    var date = new Date(Number(time * 1000));
    var y = 1900 + date.getYear();
    var m = "0" + (date.getMonth() + 1);
    var d = "0" + date.getDate();
    return y + "-" + m.substring(m.length - 2, m.length) + "-" + d.substring(d.length - 2, d.length);
  }
  async universalTimeConvertLongDate(time) {
    if (time == null) {
      return "";
    }
    var d = new Date(time);
    return d.getFullYear() + '-' + (d.getMonth() + 1) + '-' + d.getDate() + ' ' + d.getHours() + ':' + d.getMinutes() + ':' + d.getSeconds();
  }
  async universalTimeConvertShortDate(time) {
    if (time == null) {
      return "";
    }
    var d = new Date(time);
    return d.getFullYear() + '-' + (d.getMonth() + 1) + '-' + d.getDate();
  }
  async doexec(methodname, pobj, query, req, res) {
    try {
      var rtn = await this[methodname](pobj, query, req, res);
      return rtn;
    } catch (e) {
      console.log(e.stack);
      // this.logCtl.error({
      //   optitle: "Ctl调用出错",
      //   op: pobj.classname + "/" + methodname,
      //   content: e.stack,
      //   clientIp: pobj.clientIp
      // });
      return system.getResultFail(-200, "Ctl出现异常，请联系管理员");
    }
  }

  trim(o) {
    if(!o) {
      return "";
    }
    return o.toString().trim();
  }

  doTimeCondition(params, fields) {
    if (!params || !fields || fields.length == 0) {
      return;
    }

    for (var f of fields) {
        if (params[f]) {
        var suffix = this.endWith(f, 'Begin') ? " 00:00:00" : " 23:59:59";
        params[f] =  params[f] + suffix;
      }
    }
  }
  endWith(source, str){
    if(!str  || !source || source.length == 0 || str.length > source.length) {
      return false;
    }
    return source.substring(source.length - str.length) == str;
  }
}
module.exports = CtlBase;
