'use strict';

module.exports = function castFilterPath(query, schematype, val) {
  const ctx = query;
  const any$conditionals = Object.keys(val).some(function(k) {
    return k.startsWith('$') && k !== '$id' && k !== '$ref';
  });

  if (!any$conditionals) {
    return schematype.castForQueryWrapper({
      val: val,
      context: ctx
    });
  }

  const ks = Object.keys(val);

  let k = ks.length;

  while (k--) {
    const $cond = ks[k];
    const nested = val[$cond];

    if ($cond === '$not') {
      if (nested && schematype && !schematype.caster) {
        const _keys = Object.keys(nested);
        if (_keys.length && _keys[0].startsWith('$')) {
          for (const key in nested) {
            nested[key] = schematype.castForQueryWrapper({
              $conditional: key,
              val: nested[key],
              context: ctx
            });
          }
        } else {
          val[$cond] = schematype.castForQueryWrapper({
            $conditional: $cond,
            val: nested,
            context: ctx
          });
        }
        continue;
      }
      // cast(schematype.caster ? schematype.caster.schema : schema, nested, options, context);
    } else {
      val[$cond] = schematype.castForQueryWrapper({
        $conditional: $cond,
        val: nested,
        context: ctx
      });
    }
  }

  return val;
};