"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseXform = require('../base-xform');

var DateXform =
/*#__PURE__*/
function (_BaseXform) {
  _inherits(DateXform, _BaseXform);

  function DateXform(options) {
    var _this;

    _classCallCheck(this, DateXform);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(DateXform).call(this));
    _this.tag = options.tag;
    _this.attr = options.attr;
    _this.attrs = options.attrs;

    _this._format = options.format || function (dt) {
      try {
        if (Number.isNaN(dt.getTime())) return '';
        return dt.toISOString();
      } catch (e) {
        return '';
      }
    };

    _this._parse = options.parse || function (str) {
      return new Date(str);
    };

    return _this;
  }

  _createClass(DateXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      if (model) {
        xmlStream.openNode(this.tag);

        if (this.attrs) {
          xmlStream.addAttributes(this.attrs);
        }

        if (this.attr) {
          xmlStream.addAttribute(this.attr, this._format(model));
        } else {
          xmlStream.writeText(this._format(model));
        }

        xmlStream.closeNode();
      }
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (node.name === this.tag) {
        if (this.attr) {
          this.model = this._parse(node.attributes[this.attr]);
        } else {
          this.text = [];
        }
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (!this.attr) {
        this.text.push(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose() {
      if (!this.attr) {
        this.model = this._parse(this.text.join(''));
      }

      return false;
    }
  }]);

  return DateXform;
}(BaseXform);

module.exports = DateXform;
//# sourceMappingURL=date-xform.js.map
