const system = require("../../system");
const uuidv4 = require('uuid/v4');
class AuthUtils {
    constructor() {
        this.cacheManager = system.getObject("db.common.cacheManager");
    }
    getUUID() {
        var uuid = uuidv4();
        var u = uuid.replace(/\-/g, "");
        return u;
    }
    /**
     * 获取访问token信息
     * @param {*} appkey 应用key
     * @param {*} secret 应用密钥
     */
    async getTokenInfo(appkey, secret) {
        var rtnKey = this.getUUID();
        var cacheAccessKey = await this.cacheManager["ApiAccessKeyClientCache"].cache(appkey, rtnKey, 3600);
        if (cacheAccessKey) {
            rtnKey = cacheAccessKey.accessKey;
        }//获取之前的token值
        var appData = await this.cacheManager["ApiAccessKeyCache"].cache(rtnKey, secret, 3600, appkey);
        if (!appData) {
            return system.getResultFail(system.getAppInfoFail, "key或secret错误.");
        }
        if (!appData.isEnabled) {
            return system.getResultFail(system.waitAuditApp, "应用处于待审核等待启用状态.");
        }
        appData.accessKey = rtnKey;
        return system.getResultSuccess(appData);
    }

}

module.exports = AuthUtils;
