var system = require("../../../system")
const http = require("http")
const querystring = require('querystring');
var settings = require("../../../../config/settings");
const CtlBase = require("../../ctl.base");


var cacheBaseComp = null;
class AppCtl extends CtlBase {
  constructor() {
    super("common", CtlBase.getServiceName(AppCtl));
    this.userCtl = system.getObject("service.auth.userSve");
  }
  async findAllApps(p,q,req) {
    var rtns = await this.service.findAllApps(p.userid);
    return system.getResult(rtns);
  }

  async update(pobj, queryobj, req){
      return super.update(pobj, queryobj, req);
  }
  
  async initNewInstance(pobj, queryobj, req) {
    var rtn = {};
    rtn.appkey = this.getUUID();
    rtn.secret = this.getUUID();

    

  



    return system.getResult(rtn);
  }
  async resetPass(pobj, queryobj, req) {
    pobj.password = await super.encryptPasswd(settings.defaultpwd);
    var rtn = this.service.resetPass(pobj);
    return system.getResult(rtn);
  }
  async createAdminUser(pobj, queryobj, req) {
    pobj.password = settings.defaultpwd;
    var rtn = this.service.createAdminUser(pobj);
    return system.getResult(rtn);
  }
  async create(pobj, queryobj, req) {
    //设置创建者，需要同时创建app管理员、默认密码、电话
    pobj.creator_id = req.session.user.id;
    //  pobj.password=super.encryptPasswd(settings.defaultpwd);
      //构造默认的应用相关的URL
      pobj.authUrl=settings.protocalPrefix+pobj.domainName+"/auth";
      pobj.docUrl=settings.protocalPrefix+pobj.domainName+"/web/common/metaCtl/getApiDoc";
      pobj.uiconfigUrl=settings.protocalPrefix+pobj.domainName+"/api/meta/config/fetchAppConfig";
      pobj.opCacheUrl=settings.protocalPrefix+pobj.domainName+"/api/meta/opCache/opCacheData";
      pobj.notifyCacheCountUrl=settings.protocalPrefix+pobj.domainName+"/api/meta/opCache/recvNotificationForCacheCount";
    var app = await super.create(pobj,queryobj, req);
    return system.getResult(app);
  }
  async fetchApiCallData(pobj, queryobj, req){
    var curappkey=pobj.curappkey;
    //检索出作为访问时的app呼出调用数据
    var rtn= await this.service.fetchApiCallData(curappkey);
    return system.getResultSuccess(rtn);
  }
   //接受缓存计数通知接口
  async recvNotificationForCacheCount(p,q,req){
    return this.service.recvNotificationForCacheCount(p);
  }
}
module.exports = AppCtl;
