{
  template: '${tmpl}',
    data: function() {
      return {
        topcolumn: "地区",
        toponymy: "",
        activeName: 'first',
        brandOptions: [{
          value: '2019',
          label: '2019'
        }, {
          value: '2018',
          label: '2018'
        }, {
          value: '2017',
          label: '2017'
        }, {
          value: '2016',
          label: '2016'
        }, {
          value: '2015',
          label: '2015'
        }, {
          value: '2014',
          label: '2014'
        }, {
          value: '2013',
          label: '2013'
        }, {
          value: '2012',
          label: '2012'
        }, {
          value: '2011',
          label: '2011'
        }, {
          value: '2010',
          label: '2010'
        }],
        brandName: '2019',
        tableData: [],
        theTotalLogoData: {
          color: ['#7CB5EC'],
          tooltip: {
            trigger: 'axis',
            axisPointer: {
              type: 'shadow'
            }
          },
          grid: {
            left: '3%',
            right: '4%',
            bottom: '3%',
            containLabel: true
          },
          xAxis: [
            {
              type: 'category',
              data: [],
              axisTick: {
                alignWithLabel: true
              },
              axisLabel: {
                interval: 0,
                rotate: "45"
              }
            }
          ],
          yAxis: [
            {
              type: 'value'
            }
          ],
          series: [
            {
              name: '数据',
              type: 'bar',
              barWidth: '60%',
              data: []
            }
          ]
        },
        registrationsData: {
          dataset: {
            source: [
              ['score', 'amount', 'product'],
              [89.3, 58212, 'Matcha Latte'],
              [57.1, 78254, 'Milk Tea'],
              [74.4, 41032, 'Cheese Cocoa'],
              [50.1, 12755, 'Cheese Brownie'],
              [89.7, 20145, 'Matcha Cocoa'],
              [68.1, 79146, 'Tea'],
              [19.6, 91852, 'Orange Juice'],
              [10.6, 101852, 'Lemon Juice'],
              [32.7, 20112, 'Walnut Brownie'],
              [50.1, 12755, 'Cheese Brownie'],
              [89.7, 20145, 'Matcha Cocoa'],
              [68.1, 79146, 'Tea'],
              [19.6, 91852, 'Orange Juice'],
              [10.6, 101852, 'Lemon Juice'],
              [32.7, 20112, 'Walnut Brownie']
            ]
          },
          grid: { containLabel: true },
          xAxis: { name: 'amount' },
          yAxis: { type: 'category' },
          visualMap: {
            orient: 'horizontal',
            left: 'center',
            min: 10,
            max: 100,
            text: ['High Score', 'Low Score'],
            dimension: 0,
            inRange: {
              color: ['#D7DA8B', '#E15457']
            }
          },
          series: [
            {
              type: 'bar',
              encode: {
                x: 'amount',
                y: 'product'
              }
            }
          ]
        },
        titleName: '',
        loading:false
      }
    },

  methods: {
    brandEve(val) {
      console.log(val);
      this.tmnclrankdetailPost()
    },
    handleClick(tab, event) {
      console.log(tab, event);
      this.tmnclrankdetailPost()
    },
    tmnclrankdetailPost(name) {
      var obj =
      {
        year: this.brandName,
        apply_addr_province: this.toponymy || ''
      };
      var that = this;
      if (this.$route.query.num == 1) {
        this.topcolumn = '地区';
        var url = "/web/tmquery/bigtmCtl/tmaddressrankdetail";
        this.titleName = "商标量地区分布排名"
      } else if (this.$route.query.num == 2) {
        this.topcolumn = '地区';
        var url = "/web/tmquery/bigtmCtl/tmcompanyrank";
        this.titleName = "商标持有企业分布排名"
      } else if (this.$route.query.num == 3) {
        this.topcolumn = '类别';
        var url = "/web/tmquery/bigtmCtl/tmnclrankdetail";
        this.titleName = "商标类别排名"
      } else {
        return
      };
      this.loading = true;
      this.$root.postReq(url, obj).then((d) => {
        this.loading = false;
        console.log(d, '#######################################');
        this.tableData = d.data.datalist.slice(0,d.data.datalist.length-1);
        var echarts = this.$refs.theTotalLogoRef.getEchartObj();
        if (this.activeName == 'first') {
          this.theTotalLogoData.series[0].name = "商标总量";
          this.theTotalLogoData.xAxis[0].data = d.data.sqtotalX;
          this.theTotalLogoData.series[0].data = d.data.sqtotalY;
        } else if (this.activeName == 'second') {
          this.theTotalLogoData.series[0].name = "有效总量";
          this.theTotalLogoData.xAxis[0].data = d.data.zctotalX;
          this.theTotalLogoData.series[0].data = d.data.zctotalY;
        } else if (this.activeName == 'third') {
          this.theTotalLogoData.series[0].name = "年申请量";
          this.theTotalLogoData.xAxis[0].data = d.data.yearsqtotalX;
          this.theTotalLogoData.series[0].data = d.data.yearsqtotalY;
        } else if (this.activeName == 'fourth') {
          this.theTotalLogoData.series[0].name = "年注册量";
          this.theTotalLogoData.xAxis[0].data = d.data.yearzctotalX;
          this.theTotalLogoData.series[0].data = d.data.yearzctotalY;
        }
        echarts.setOption(this.theTotalLogoData);
        window.addEventListener("resize", function () {
          echarts.resize();
        });
        this.$forceUpdate();
      }).catch(function (e) {
        this.loading = false;
        that.$message.warning(`操作失败，请刷新页面后重新操作`);
      });
    }
  },
  mounted: function() {
    this.brandName = this.$route.query.year || '2019';
    this.toponymy = this.$route.query.toponymy;
    this.tmnclrankdetailPost(this.$route.query.toponymy)
  },
  vname: "gsb-tmbigdatadetail"
}
