const system=require("../../../system");
var settings=require("../../../../config/settings");
class TmqueryService {
  constructor(){
    this.GsbByTmSearchApi=system.getObject("api.tmquery.bytmsearch");
  }
  //商标总量接口
  async bigtmcount(obj){
    var result = {tmtotal:""};
    var tmreg_year = obj.tmreg_year == null ? "" : obj.tmreg_year;
    var apply_addr_province = obj.apply_addr_province==null ?"":obj.apply_addr_province;
    var obj ={
      params:[],
      seltype:0
    }
    if(tmreg_year!=""&&tmreg_year!=null){
      obj.params.push({
        "range": {
    			"tmreg_year": {
            "gte":1900,
            "lte":tmreg_year
          }
    		}
      });
    }
    if(apply_addr_province!=""&&apply_addr_province!=null){
      obj.params.push({
        "term": {
          "apply_addr_province": apply_addr_province
        }
      });
    }
    var tm = await this.GsbByTmSearchApi.provincePubstatusAggs(obj);
    if(tm.status==0){
      result.tmtotal=tm.data.total;
    }
    return system.getResult2(result,null);
  }
  //商标有效注册量
  async bigtmregistcount(obj){
    console.log("---------------bigtmregistcount-------------------");
    var result = {tmregtotal:""};
    var tmreg_year = obj.tmreg_year == null ? "" : obj.tmreg_year;
    var apply_addr_province = obj.apply_addr_province==null ?"":obj.apply_addr_province;
    var obj ={
      params:[{
        "term":{
          "status":3
        }
      }],
      seltype:0
    }
    if(tmreg_year!=""&&tmreg_year!=null){
      obj.params.push({
        "term": {
    			"tmreg_year": tmreg_year
    		}
      });
    }
    if(apply_addr_province!=""&&apply_addr_province!=null){
      obj.params.push({
        "term": {
          "apply_addr_province": apply_addr_province
        }
      });
    }
    console.log(obj);
    var tm = await this.GsbByTmSearchApi.provincePubstatusAggs(obj);
    console.log(tm);
    if(tm.status==0){
      result.tmregtotal=tm.data.total;
    }
    return system.getResult2(result,null);
  }
  //商标申请中总量
  async bigtmapplicationcount(obj){
    var result = {tmsqtotal:""};
    var tmreg_year = obj.tmreg_year == null ? "" : obj.tmreg_year;
    var apply_addr_province = obj.apply_addr_province==null ?"":obj.apply_addr_province;
    var obj ={
      params:[],
      seltype:0
    }
    if(tmreg_year!=""&&tmreg_year!=null){
      obj.params.push({
        "term": {
    			"apply_year": tmreg_year
    		}
      });
    }
    if(apply_addr_province!=""&&apply_addr_province!=null){
      obj.params.push({
        "term": {
          "apply_addr_province": apply_addr_province
        }
      });
    }
    var tm = await this.GsbByTmSearchApi.provincePubstatusAggs(obj);
    console.log(tm);
    if(tm.status==0){
      result.tmsqtotal=tm.data.total;
    }
    return system.getResult2(result,null);
  }
  //商标申请企业总量
  async bigtmcompanycount(obj){
    var result = {tmcompanytotal:""};
    var tmreg_year = obj.tmreg_year == null ? "" : obj.tmreg_year;
    var apply_addr_province = obj.apply_addr_province==null ?"":obj.apply_addr_province;
    var obj ={
      params:[]
    }
    if(tmreg_year!=""&&tmreg_year!=null){
      obj.params.push({
        "term": {
    			"apply_year": tmreg_year
    		}
      });
    }
    if(apply_addr_province!=""&&apply_addr_province!=null){
      obj.params.push({
        "term": {
          "apply_addr_province": apply_addr_province
        }
      });
    }
    var tm = await this.GsbByTmSearchApi.tmcompanycountAggs(obj);
    // console.log(tm);
    if(tm.status==0){
      result.tmcompanytotal=tm.buckets.value;
    }
    return system.getResult2(result,null);
  }
  //商标申请总量聚合,根据商标状态,申请，注册,
  async bigtmcountjuhe(obj){
    var result = { tmcount:[]}
    var status = obj.status == null ? "" : obj.status;
    var seltype = obj.seltype == null ? "" : obj.seltype;
    var apply_addr_province = obj.apply_addr_province==null ?"":obj.apply_addr_province;
    var obj = {
      params:[]
    }
    if(seltype!=""&&seltype!=null){
      obj.seltype=seltype;
      if(seltype==2){
        obj.areaname=apply_addr_province;
      }
    }
    if(status!=""&&status!=null){
      if(status==3){
        obj.params.push({
          "term": {
      			"status": status
      		}
        });
      }
    }
    if(apply_addr_province!=""&&apply_addr_province!=null){
      obj.params.push({
        "term": {
          "apply_addr_province": apply_addr_province
        }
      });
    }
    var tm = await this.GsbByTmSearchApi.provincePubstatusAggs(obj);
    var counts =[];
    if(tm.status==0){
      tm.buckets.forEach(function(buck){
        var cn ={
          code:buck.key,
          count:buck.doc_count
        }
        counts.push(cn);
      });
      result.tmcount=counts;
    }
    console.log(tm);
    return system.getResult2(result,null);
  }
  //商标申请总量聚合,根据商标状态申请，注册,年份
  async bigtmcountyearjuhe(obj){
    console.log("=================bigtmcountyearjuhe======================");
    console.log(obj);
    var result = { tmyearcount:[]};
    var status = obj.status == null ? "" : obj.status;
    var seltype = obj.seltype == null ? "" : obj.seltype;
    var tmreg_year = obj.tmreg_year == null ? "" : obj.tmreg_year;
    var apply_addr_province = obj.apply_addr_province==null ?"":obj.apply_addr_province;
    var obj = {
      params:[]
    }
    if(status!=""&&status!=null){
      if(status==1){
        if(tmreg_year!=""&&tmreg_year!=null){
          obj.params.push({
            "term": {
        			"apply_year": tmreg_year
        		}
          });
        }
      }
      if(status==3){
        obj.params.push({
          "term": {
      			"status": status
      		}
        });
        if(tmreg_year!=""&&tmreg_year!=null){
          obj.params.push({
            "term": {
        			"tmreg_year": tmreg_year
        		}
          });
        }
      }
    }
    if(seltype!=""&&seltype!=null){
      obj.seltype=seltype;
      if(seltype==2){
        console.log("+++++++++++++++++++++++++++++++");
        obj.areaname=apply_addr_province;
      }
    }
    if(apply_addr_province!=""&&apply_addr_province!=null){
      obj.params.push({
        "term": {
          "apply_addr_province": apply_addr_province
        }
      });
    }
    var tm = await this.GsbByTmSearchApi.provincePubstatusAggs(obj);
    var counts =[];
    if(tm.status==0){
      tm.buckets.forEach(function(buck){
        var cn ={
          code:buck.key,
          count:buck.doc_count
        }
        counts.push(cn);
      });
      result.tmyearcount=counts;
    }
    console.log(tm);
    return system.getResult2(result,null);
  }
  //商标地域分布统计,状态申请，注册,年份
  async bigtmcompanyjuhe(obj){
    console.log("==============bigtmcompanyjuhe=========================");
    console.log(obj);
    var result = { tmcompanycount:[]}
    var status = obj.status == null ? "" : obj.status;
    var seltype = obj.seltype == null ? "" : obj.seltype;
    var tmreg_year = obj.tmreg_year == null ? "" : obj.tmreg_year;
    var apply_addr_province = obj.apply_addr_province==null ?"":obj.apply_addr_province;
    var obj = {
      params:[]
    }
    if(status!=""&&status!=null){
      if(status==1){
        if(tmreg_year!=""&&tmreg_year!=null){
          obj.params.push({
            "term": {
              "apply_year": tmreg_year
            }
          });
        }
      }
      if(status==3){
        obj.params.push({
          "term": {
            "status": status
          }
        });
        if(tmreg_year!=""&&tmreg_year!=null){
          obj.params.push({
            "term": {
              "tmreg_year": tmreg_year
            }
          });
        }
      }
    }
    if(seltype!=""&&seltype!=null){
      obj.seltype=seltype;
      if(seltype==2){
        obj.areaname=apply_addr_province;
      }
    }
    if(apply_addr_province!=""&&apply_addr_province!=null){
      obj.params.push({
        "term": {
          "apply_addr_province": apply_addr_province
        }
      });
    }
    var tm = await this.GsbByTmSearchApi.tmcompanyAggs(obj);
    console.log(tm.buckets);
    var counts =[];
    if(tm.status==0){
      tm.buckets.forEach(function(buck){
        var addr ={
          city:buck.key,
          count:buck.companycount
        }
        counts.push(addr);
      });
      result.tmcompanycount=counts;
    }
    // console.log(tm);
    return system.getResult2(result,null);
  }
  //商标类别申请排名
  async bigtmnclrank(obj){
    console.log("==================bigtmnclrank=====================");
    console.log(obj);
    var result = {tmnclrank:[]};
    var tmreg_year = obj.tmreg_year == null ? "" : obj.tmreg_year;
    var apply_addr_province = obj.apply_addr_province==null ?"":obj.apply_addr_province;
    var obj ={
      params:[],
      seltype:3
    }
    if(tmreg_year!=""&&tmreg_year!=null){
      obj.params.push({
        "term": {
    			"apply_year": tmreg_year
    		}
      });
    }
    if(apply_addr_province!=""&&apply_addr_province!=null){
      obj.params.push({
        "term": {
          "apply_addr_province": apply_addr_province
        }
      });
    }
    var tm = await this.GsbByTmSearchApi.provincePubstatusAggs(obj);
    console.log(tm.buckets);
    var counts =[];
    if(tm.status==0){
      tm.buckets.forEach(function(buck){
        var cn ={
          code:buck.key,
          count:buck.doc_count
        }
        counts.push(cn);
      });
      result.tmnclrank=counts;
    }
    return system.getResult2(result,null);
  }
  //商标企业排名
  async bigtmcompanyrank(obj){
    console.log("=================bigtmcompanyrank======================");
    console.log(obj);
    var result = {tmcompanyrank:[]};
    var tmreg_year = obj.tmreg_year == null ? "" : obj.tmreg_year;
    var apply_addr_province = obj.apply_addr_province==null ?"":obj.apply_addr_province;
    var obj ={
      params:[]
    }
    if(tmreg_year!=""&&tmreg_year!=null){
      obj.params.push({
        "term": {
          "apply_year": tmreg_year
        }
      });
    }
    if(apply_addr_province!=""&&apply_addr_province!=null){
      obj.params.push({
        "term": {
          "apply_addr_province": apply_addr_province
        }
      });
      obj.seltype=2;
      obj.areaname=apply_addr_province;
    }else{
      obj.seltype=1;
    }
    var tm = await this.GsbByTmSearchApi.tmcompanyAggs(obj);

    console.log("coooooooooooooooooooooooooooooooooooooooooooooooooooooooo");
    console.log(tm.buckets);
    var counts =[];
    if(tm.status==0){
      tm.buckets.forEach(function(buck){
        var cn ={
          code:buck.key,
          count:buck.companycount
        }
        counts.push(cn);
      });
      result.tmcompanyrank=counts;
    }
    return system.getResult2(result,null);
  }
  //商标地区排名
  async bigtmaddrrank(obj){
    console.log("==================bigtmaddrrank=====================");
    console.log(obj);
    var result = {tmaddrrank:[]};
    var tmreg_year = obj.tmreg_year == null ? "" : obj.tmreg_year;
    var apply_addr_province = obj.apply_addr_province==null ?"":obj.apply_addr_province;
    var obj ={
      params:[]
    }
    if(tmreg_year!=""&&tmreg_year!=null){
      obj.params.push({
        "term": {
          "apply_year": tmreg_year
        }
      });
    }
    if(apply_addr_province!=""&&apply_addr_province!=null){
      obj.params.push({
        "term": {
          "apply_addr_province": apply_addr_province
        }
      });
      obj.seltype=2;
      obj.areaname=apply_addr_province;
    }else{
      obj.seltype=1;
    }
    var tm = await this.GsbByTmSearchApi.provincePubstatusAggs(obj);
    console.log(tm.buckets);
    var counts =[];
    if(tm.status==0){
      tm.buckets.forEach(function(buck){
        var cn ={
          code:buck.key,
          count:buck.doc_count
        }
        counts.push(cn);
      });
      result.tmaddrrank=counts;
    }
    return system.getResult2(result,null);
  }
  //商标申请及注册趋势
  async bigtmtrend(obj){
    var result = {tmtrend:[]};
    var status = obj.status == null ? "" : obj.status;
    var seltype = obj.seltype == null ? "" : obj.seltype;
    var apply_addr_province = obj.apply_addr_province==null ?"":obj.apply_addr_province;
    var obj ={
      params:[],
      seltype:seltype
    }
    if(apply_addr_province!=""&&apply_addr_province!=null){
      obj.params.push({
        "term": {
          "apply_addr_province": apply_addr_province
        }
      });
    }
    if(status!=""&&status!=null){
      if(status==3){
        obj.params.push({
          "term": {
      			"status": status
      		}
        });
      }
    }
    var tm = await this.GsbByTmSearchApi.provincePubstatusAggs(obj);
    var counts =[];
    if(tm.status==0){
      tm.buckets.forEach(function(buck){
        var cn ={
          code:buck.key,
          count:buck.doc_count
        }
        counts.push(cn);
      });
      result.tmtrend=counts;
    }
    return system.getResult2(result,null);
  }


}
module.exports=TmqueryService;
// var test = new TmqueryService();
// test.bigtmcompanyjuhe({status:3,tmreg_year:2018,seltype:1,apply_addr_province:""}).then(function(d){
//   console.log("#################################");
//   console.log(d);
// })
