const CacheBase=require("../cache.base");
const system=require("../../system");
//商标大数据缓存---商标申请企业总量
class EmbedBigdataTmCountCache extends CacheBase{
   constructor(){
     super();
     this.prefix="embed_bigdata_tmentcount_";
     this.redisClient=system.getObject("util.redisClient");
   }
   async get(k){
        var prefix = this.prefix+k;
        var result = await this.redisClient.get(key);
        var obj = null;
        var time = Date.parse(new Date())/1000;
        if(result){
            obj=JSON.parse(result);
            if(!obj.time){
                obj = null;
            }
        }
        if(!obj || obj.time<=time){//无缓存 或 缓存令牌失效
            return null;
        }else{//有缓存 且 未失效
            return obj;
        }
   }
   async set(k,obj){
        var key = this.prefix+k;
        var time = Date.parse(new Date())/1000;
        obj["time"]= time+604800;
        var objstring=JSON.stringify(obj);
        await this.redisClient.set(key,objstring);
        return obj;
   }
}
module.exports=EmbedBigdataTmCountCache;
