var System = require("../../../system");
var settings = require("../../../../config/settings");
const logCtl = System.getObject("web.common.oplogCtl");
const CtlBase = require("../../ctl.base");
class bytmmonitCtl extends CtlBase {
  constructor() {
    super("tmquery",CtlBase.getServiceName(bytmmonitCtl));
    this.gsbicsearch = System.getObject("api.tmquery.gsbicsearch");
  }
  async getCompanyInfoNoUser(queryobj, qobj, req) {
    var result = {
      code: 1,
      message: "success",
      data: null
    };
    try {
      var tCompanyName = qobj.company_name || "";
      if (!tCompanyName || tCompanyName == "undefined") {
        result.code = -102;
        result.message = "company_name参数有误";
        return result;
      }
      var query = { isVerify: -1, companyName: tCompanyName };
      var tResult = await this.gsbicsearch.companyonesearch(query);
      console.log("------------------------------");
      console.log(tResult);
      if (tResult.status == 0 && tResult.data.list.length > 0) {
        result.data = tResult.data.list[0];
      }
      return result;
    } catch (e) {
      //日志记录
      logCtl.error({
        optitle: "获取标眼查商标监控工商信息Error",
        op: "base/controller/impl/bytmmonitCtl/getCompanyInfo",
        content: e.stack,
        clientIp: req.clientIp
      });
      result.code = -200;
      result.message = "操作异常";
      return result;
    }
  }
}
module.exports = bytmmonitCtl;
